/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spell;

import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.MultiFields;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.spell.Dictionary;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.suggest.InputIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRefBuilder;

public class HighFrequencyDictionary
implements Dictionary {
    private IndexReader reader;
    private String field;
    private float thresh;

    public HighFrequencyDictionary(IndexReader reader, String field, float thresh) {
        this.reader = reader;
        this.field = field;
        this.thresh = thresh;
    }

    @Override
    public final InputIterator getEntryIterator() throws IOException {
        return new HighFrequencyIterator();
    }

    final class HighFrequencyIterator
    implements InputIterator {
        private final BytesRefBuilder spare = new BytesRefBuilder();
        private final TermsEnum termsEnum;
        private int minNumDocs;
        private long freq;

        HighFrequencyIterator() throws IOException {
            Terms terms = MultiFields.getTerms(HighFrequencyDictionary.this.reader, HighFrequencyDictionary.this.field);
            this.termsEnum = terms != null ? terms.iterator(null) : null;
            this.minNumDocs = (int)(HighFrequencyDictionary.this.thresh * (float)HighFrequencyDictionary.this.reader.numDocs());
        }

        private boolean isFrequent(int freq) {
            return freq >= this.minNumDocs;
        }

        @Override
        public long weight() {
            return this.freq;
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.termsEnum != null) {
                BytesRef next;
                while ((next = this.termsEnum.next()) != null) {
                    if (!this.isFrequent(this.termsEnum.docFreq())) continue;
                    this.freq = this.termsEnum.docFreq();
                    this.spare.copyBytes(next);
                    return this.spare.get();
                }
            }
            return null;
        }

        @Override
        public Comparator<BytesRef> getComparator() {
            if (this.termsEnum == null) {
                return null;
            }
            return this.termsEnum.getComparator();
        }

        @Override
        public BytesRef payload() {
            return null;
        }

        @Override
        public boolean hasPayloads() {
            return false;
        }

        @Override
        public Set<BytesRef> contexts() {
            return null;
        }

        @Override
        public boolean hasContexts() {
            return false;
        }
    }
}

