/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.postingshighlight;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.postingshighlight.CustomPassageFormatter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.postingshighlight.Passage;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.postingshighlight.PassageFormatter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.postingshighlight.Snippet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.postingshighlight.XPostingsHighlighter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;

public final class CustomPostingsHighlighter
extends XPostingsHighlighter {
    private static final Snippet[] EMPTY_SNIPPET = new Snippet[0];
    private static final Passage[] EMPTY_PASSAGE = new Passage[0];
    private final CustomPassageFormatter passageFormatter;
    private final int noMatchSize;
    private final int totalContentLength;
    private final String[] fieldValues;
    private final int[] fieldValuesOffsets;
    private int currentValueIndex = 0;
    private BreakIterator breakIterator;

    public CustomPostingsHighlighter(CustomPassageFormatter passageFormatter, List<Object> fieldValues, boolean mergeValues, int maxLength, int noMatchSize) {
        super(maxLength);
        this.passageFormatter = passageFormatter;
        this.noMatchSize = noMatchSize;
        if (mergeValues) {
            String rawValue = Strings.collectionToDelimitedString(fieldValues, String.valueOf(this.getMultiValuedSeparator("")));
            String fieldValue = rawValue.substring(0, Math.min(rawValue.length(), maxLength));
            this.fieldValues = new String[]{fieldValue};
            this.fieldValuesOffsets = new int[]{0};
            this.totalContentLength = fieldValue.length();
        } else {
            this.fieldValues = new String[fieldValues.size()];
            this.fieldValuesOffsets = new int[fieldValues.size()];
            int contentLength = 0;
            int offset = 0;
            int previousLength = -1;
            for (int i = 0; i < fieldValues.size(); ++i) {
                String fieldValue;
                String rawValue = fieldValues.get(i).toString();
                this.fieldValues[i] = fieldValue = rawValue.substring(0, Math.min(rawValue.length(), maxLength));
                contentLength += fieldValue.length();
                this.fieldValuesOffsets[i] = offset += previousLength + 1;
                previousLength = fieldValue.length();
            }
            this.totalContentLength = contentLength;
        }
    }

    public Snippet[] highlightDoc(String field, BytesRef[] terms, IndexSearcher searcher, int docId, int maxPassages) throws IOException {
        IndexReader reader = searcher.getIndexReader();
        IndexReaderContext readerContext = reader.getContext();
        List<AtomicReaderContext> leaves = readerContext.leaves();
        String[] contents = new String[]{this.loadCurrentFieldValue()};
        Map<Integer, Object> snippetsMap = this.highlightField(field, contents, this.getBreakIterator(field), terms, new int[]{docId}, leaves, maxPassages);
        ++this.currentValueIndex;
        Object snippetObject = snippetsMap.get(docId);
        if (snippetObject != null && snippetObject instanceof Snippet[]) {
            return (Snippet[])snippetObject;
        }
        return EMPTY_SNIPPET;
    }

    @Override
    protected int getContentLength(String field, int docId) {
        return this.totalContentLength;
    }

    @Override
    protected int getOffsetForCurrentValue(String field, int docId) {
        if (this.currentValueIndex < this.fieldValuesOffsets.length) {
            return this.fieldValuesOffsets[this.currentValueIndex];
        }
        throw new IllegalArgumentException("No more values offsets to return");
    }

    public void setBreakIterator(BreakIterator breakIterator) {
        this.breakIterator = breakIterator;
    }

    @Override
    protected PassageFormatter getFormatter(String field) {
        return this.passageFormatter;
    }

    @Override
    protected BreakIterator getBreakIterator(String field) {
        if (this.breakIterator == null) {
            return super.getBreakIterator(field);
        }
        return this.breakIterator;
    }

    @Override
    protected char getMultiValuedSeparator(String field) {
        return '\u2029';
    }

    @Override
    protected Passage[] getEmptyHighlight(String fieldName, BreakIterator bi, int maxPassages) {
        if (this.noMatchSize > 0) {
            return super.getEmptyHighlight(fieldName, bi, 1);
        }
        return EMPTY_PASSAGE;
    }

    @Override
    protected String[][] loadFieldValues(IndexSearcher searcher, String[] fields, int[] docids, int maxLength) throws IOException {
        return new String[][]{{this.loadCurrentFieldValue()}};
    }

    protected String loadCurrentFieldValue() {
        if (this.currentValueIndex < this.fieldValues.length) {
            return this.fieldValues[this.currentValueIndex];
        }
        throw new IllegalArgumentException("No more values to return");
    }
}

