/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.join.ToParentBlockJoinFieldComparator;

public class ToParentBlockJoinSortField
extends SortField {
    private final boolean order;
    private final Filter parentFilter;
    private final Filter childFilter;

    public ToParentBlockJoinSortField(String field, SortField.Type type, boolean reverse, Filter parentFilter, Filter childFilter) {
        super(field, type, reverse);
        this.order = reverse;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    public ToParentBlockJoinSortField(String field, SortField.Type type, boolean reverse, boolean order, Filter parentFilter, Filter childFilter) {
        super(field, type, reverse);
        this.order = order;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        FieldComparator<Object> wrappedFieldComparator = super.getComparator(numHits + 1, sortPos);
        if (this.order) {
            return new ToParentBlockJoinFieldComparator.Highest(wrappedFieldComparator, this.parentFilter, this.childFilter, numHits);
        }
        return new ToParentBlockJoinFieldComparator.Lowest(wrappedFieldComparator, this.parentFilter, this.childFilter, numHits);
    }
}

