/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;

public class ToChildBlockJoinQuery
extends Query {
    static final String INVALID_QUERY_MESSAGE = "Parent query yields document which is not matched by parents filter, docID=";
    private final Filter parentsFilter;
    private final Query parentQuery;
    private final Query origParentQuery;
    private final boolean doScores;

    public ToChildBlockJoinQuery(Query parentQuery, Filter parentsFilter, boolean doScores) {
        this.origParentQuery = parentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    private ToChildBlockJoinQuery(Query origParentQuery, Query parentQuery, Filter parentsFilter, boolean doScores) {
        this.origParentQuery = origParentQuery;
        this.parentQuery = parentQuery;
        this.parentsFilter = parentsFilter;
        this.doScores = doScores;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher) throws IOException {
        return new ToChildBlockJoinWeight(this, this.parentQuery.createWeight(searcher), this.parentsFilter, this.doScores);
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.parentQuery.extractTerms(terms);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query parentRewrite = this.parentQuery.rewrite(reader);
        if (parentRewrite != this.parentQuery) {
            ToChildBlockJoinQuery rewritten = new ToChildBlockJoinQuery(this.parentQuery, parentRewrite, this.parentsFilter, this.doScores);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    @Override
    public String toString(String field) {
        return "ToChildBlockJoinQuery (" + this.parentQuery.toString() + ")";
    }

    @Override
    public boolean equals(Object _other) {
        if (_other instanceof ToChildBlockJoinQuery) {
            ToChildBlockJoinQuery other = (ToChildBlockJoinQuery)_other;
            return this.origParentQuery.equals(other.origParentQuery) && this.parentsFilter.equals(other.parentsFilter) && this.doScores == other.doScores && super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int hash = super.hashCode();
        hash = 31 * hash + this.origParentQuery.hashCode();
        hash = 31 * hash + new Boolean(this.doScores).hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    @Override
    public ToChildBlockJoinQuery clone() {
        return new ToChildBlockJoinQuery(this.origParentQuery.clone(), this.parentsFilter, this.doScores);
    }

    static class ToChildBlockJoinScorer
    extends Scorer {
        private final Scorer parentScorer;
        private final FixedBitSet parentBits;
        private final boolean doScores;
        private final Bits acceptDocs;
        private float parentScore;
        private int parentFreq = 1;
        private int childDoc = -1;
        private int parentDoc;

        public ToChildBlockJoinScorer(Weight weight, Scorer parentScorer, FixedBitSet parentBits, boolean doScores, Bits acceptDocs) {
            super(weight);
            this.doScores = doScores;
            this.parentBits = parentBits;
            this.parentScorer = parentScorer;
            this.acceptDocs = acceptDocs;
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.parentScorer, "BLOCK_JOIN"));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int nextDoc() throws IOException {
            do lbl-1000:
            // 3 sources

            {
                block6: {
                    if (this.childDoc + 1 != this.parentDoc) break block6;
                    while (true) {
                        this.parentDoc = this.parentScorer.nextDoc();
                        this.validateParentDoc();
                        if (this.parentDoc == 0) {
                            this.parentDoc = this.parentScorer.nextDoc();
                            this.validateParentDoc();
                        }
                        if (this.parentDoc == 0x7FFFFFFF) {
                            this.childDoc = 0x7FFFFFFF;
                            return this.childDoc;
                        }
                        this.childDoc = 1 + this.parentBits.prevSetBit(this.parentDoc - 1);
                        if (this.childDoc == this.parentDoc) continue;
                        if (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc)) ** GOTO lbl-1000
                        if (this.childDoc < this.parentDoc) break;
                    }
                    if (this.doScores) {
                        this.parentScore = this.parentScorer.score();
                        this.parentFreq = this.parentScorer.freq();
                    }
                    return this.childDoc;
                }
                if (!ToChildBlockJoinScorer.$assertionsDisabled && this.childDoc >= this.parentDoc) {
                    throw new AssertionError((Object)("childDoc=" + this.childDoc + " parentDoc=" + this.parentDoc));
                }
                ++this.childDoc;
            } while (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc));
            return this.childDoc;
        }

        private void validateParentDoc() {
            if (this.parentDoc != Integer.MAX_VALUE && !this.parentBits.get(this.parentDoc)) {
                throw new IllegalStateException(ToChildBlockJoinQuery.INVALID_QUERY_MESSAGE + this.parentDoc);
            }
        }

        @Override
        public int docID() {
            return this.childDoc;
        }

        @Override
        public float score() throws IOException {
            return this.parentScore;
        }

        @Override
        public int freq() throws IOException {
            return this.parentFreq;
        }

        @Override
        public int advance(int childTarget) throws IOException {
            assert (childTarget >= this.parentBits.length() || !this.parentBits.get(childTarget));
            if (childTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                this.childDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            assert (this.childDoc == -1 || childTarget != this.parentDoc) : "childTarget=" + childTarget;
            if (this.childDoc == -1 || childTarget > this.parentDoc) {
                this.parentDoc = this.parentScorer.advance(childTarget);
                this.validateParentDoc();
                assert (this.parentDoc > childTarget);
                if (this.parentDoc == Integer.MAX_VALUE) {
                    this.childDoc = Integer.MAX_VALUE;
                    return Integer.MAX_VALUE;
                }
                if (this.doScores) {
                    this.parentScore = this.parentScorer.score();
                    this.parentFreq = this.parentScorer.freq();
                }
                int firstChild = this.parentBits.prevSetBit(this.parentDoc - 1);
                childTarget = Math.max(childTarget, firstChild);
            }
            assert (childTarget < this.parentDoc);
            this.childDoc = childTarget;
            if (this.acceptDocs != null && !this.acceptDocs.get(this.childDoc)) {
                this.nextDoc();
            }
            return this.childDoc;
        }

        @Override
        public long cost() {
            return this.parentScorer.cost();
        }
    }

    private static class ToChildBlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight parentWeight;
        private final Filter parentsFilter;
        private final boolean doScores;

        public ToChildBlockJoinWeight(Query joinQuery, Weight parentWeight, Filter parentsFilter, boolean doScores) {
            this.joinQuery = joinQuery;
            this.parentWeight = parentWeight;
            this.parentsFilter = parentsFilter;
            this.doScores = doScores;
        }

        @Override
        public Query getQuery() {
            return this.joinQuery;
        }

        @Override
        public float getValueForNormalization() throws IOException {
            return this.parentWeight.getValueForNormalization() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        @Override
        public void normalize(float norm, float topLevelBoost) {
            this.parentWeight.normalize(norm, topLevelBoost * this.joinQuery.getBoost());
        }

        @Override
        public Scorer scorer(AtomicReaderContext readerContext, Bits acceptDocs) throws IOException {
            Scorer parentScorer = this.parentWeight.scorer(readerContext, null);
            if (parentScorer == null) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(readerContext, null);
            if (parents == null) {
                return null;
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
            }
            return new ToChildBlockJoinScorer(this, parentScorer, (FixedBitSet)parents, this.doScores, acceptDocs);
        }

        @Override
        public Explanation explain(AtomicReaderContext reader, int doc) throws IOException {
            throw new UnsupportedOperationException(this.getClass().getName() + " cannot explain match on parent document");
        }

        @Override
        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }
}

