/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.grouping.AbstractFirstPassGroupingCollector;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.mutable.MutableValue;

public class FunctionFirstPassGroupingCollector
extends AbstractFirstPassGroupingCollector<MutableValue> {
    private final ValueSource groupByVS;
    private final Map<?, ?> vsContext;
    private FunctionValues.ValueFiller filler;
    private MutableValue mval;

    public FunctionFirstPassGroupingCollector(ValueSource groupByVS, Map<?, ?> vsContext, Sort groupSort, int topNGroups) throws IOException {
        super(groupSort, topNGroups);
        this.groupByVS = groupByVS;
        this.vsContext = vsContext;
    }

    @Override
    protected MutableValue getDocGroupValue(int doc) {
        this.filler.fillValue(doc);
        return this.mval;
    }

    @Override
    protected MutableValue copyDocGroupValue(MutableValue groupValue, MutableValue reuse) {
        if (reuse != null) {
            reuse.copy(groupValue);
            return reuse;
        }
        return groupValue.duplicate();
    }

    @Override
    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        super.setNextReader(readerContext);
        FunctionValues values = this.groupByVS.getValues(this.vsContext, readerContext);
        this.filler = values.getValueFiller();
        this.mval = this.filler.getValue();
    }
}

