/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.PhraseQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.similarities.Similarity;

final class ExactPhraseScorer
extends Scorer {
    private final int endMinus1;
    private static final int CHUNK = 4096;
    private int gen;
    private final int[] counts = new int[4096];
    private final int[] gens = new int[4096];
    private final long cost;
    private final ChunkState[] chunkStates;
    private final DocsAndPositionsEnum lead;
    private int docID = -1;
    private int freq;
    private final Similarity.SimScorer docScorer;

    ExactPhraseScorer(Weight weight, PhraseQuery.PostingsAndFreq[] postings, Similarity.SimScorer docScorer) throws IOException {
        super(weight);
        this.docScorer = docScorer;
        this.chunkStates = new ChunkState[postings.length];
        this.endMinus1 = postings.length - 1;
        this.lead = postings[0].postings;
        this.cost = this.lead.cost();
        for (int i = 0; i < postings.length; ++i) {
            this.chunkStates[i] = new ChunkState(postings[i].postings, -postings[i].position);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int doNext(int doc) throws IOException {
        while (true) {
            for (int i = 1; i < this.chunkStates.length; ++i) {
                int d;
                DocsAndPositionsEnum de = this.chunkStates[i].posEnum;
                if (de.docID() >= doc || (d = de.advance(doc)) <= doc) continue;
                doc = d;
                doc = this.lead.advance(doc);
            }
            if (doc == Integer.MAX_VALUE) {
                return doc;
            }
            if (this.phraseFreq() > 0) {
                return doc;
            }
            doc = this.lead.nextDoc();
        }
    }

    @Override
    public int nextDoc() throws IOException {
        this.docID = this.doNext(this.lead.nextDoc());
        return this.docID;
    }

    @Override
    public int advance(int target) throws IOException {
        this.docID = this.doNext(this.lead.advance(target));
        return this.docID;
    }

    public String toString() {
        return "ExactPhraseScorer(" + this.weight + ")";
    }

    @Override
    public int freq() {
        return this.freq;
    }

    @Override
    public int docID() {
        return this.docID;
    }

    @Override
    public float score() {
        return this.docScorer.score(this.docID, this.freq);
    }

    private int phraseFreq() throws IOException {
        this.freq = 0;
        for (int i = 0; i < this.chunkStates.length; ++i) {
            ChunkState cs = this.chunkStates[i];
            cs.posLimit = cs.posEnum.freq();
            cs.pos = cs.offset + cs.posEnum.nextPosition();
            cs.posUpto = 1;
            cs.lastPos = -1;
        }
        int chunkStart = 0;
        int chunkEnd = 4096;
        boolean end = false;
        while (!end) {
            ++this.gen;
            if (this.gen == 0) {
                Arrays.fill(this.gens, 0);
                ++this.gen;
            }
            ChunkState cs = this.chunkStates[0];
            while (cs.pos < chunkEnd) {
                if (cs.pos > cs.lastPos) {
                    cs.lastPos = cs.pos;
                    int posIndex = cs.pos - chunkStart;
                    this.counts[posIndex] = 1;
                    assert (this.gens[posIndex] != this.gen);
                    this.gens[posIndex] = this.gen;
                }
                if (cs.posUpto == cs.posLimit) {
                    end = true;
                    break;
                }
                ++cs.posUpto;
                cs.pos = cs.offset + cs.posEnum.nextPosition();
            }
            boolean any = true;
            for (int t = 1; t < this.endMinus1; ++t) {
                ChunkState cs2 = this.chunkStates[t];
                any = false;
                while (cs2.pos < chunkEnd) {
                    if (cs2.pos > cs2.lastPos) {
                        cs2.lastPos = cs2.pos;
                        int posIndex = cs2.pos - chunkStart;
                        if (posIndex >= 0 && this.gens[posIndex] == this.gen && this.counts[posIndex] == t) {
                            int n = posIndex;
                            this.counts[n] = this.counts[n] + 1;
                            any = true;
                        }
                    }
                    if (cs2.posUpto == cs2.posLimit) {
                        end = true;
                        break;
                    }
                    ++cs2.posUpto;
                    cs2.pos = cs2.offset + cs2.posEnum.nextPosition();
                }
                if (!any) break;
            }
            if (!any) {
                chunkStart += 4096;
                chunkEnd += 4096;
                continue;
            }
            ChunkState cs3 = this.chunkStates[this.endMinus1];
            while (cs3.pos < chunkEnd) {
                if (cs3.pos > cs3.lastPos) {
                    cs3.lastPos = cs3.pos;
                    int posIndex = cs3.pos - chunkStart;
                    if (posIndex >= 0 && this.gens[posIndex] == this.gen && this.counts[posIndex] == this.endMinus1) {
                        ++this.freq;
                    }
                }
                if (cs3.posUpto == cs3.posLimit) {
                    end = true;
                    break;
                }
                ++cs3.posUpto;
                cs3.pos = cs3.offset + cs3.posEnum.nextPosition();
            }
            chunkStart += 4096;
            chunkEnd += 4096;
        }
        return this.freq;
    }

    @Override
    public long cost() {
        return this.cost;
    }

    private static final class ChunkState {
        final DocsAndPositionsEnum posEnum;
        final int offset;
        int posUpto;
        int posLimit;
        int pos;
        int lastPos;

        public ChunkState(DocsAndPositionsEnum posEnum, int offset) {
            this.posEnum = posEnum;
            this.offset = offset;
        }
    }
}

