/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.sandbox.queries.regex;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FilteredTermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.sandbox.queries.regex.RegexCapabilities;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.StringHelper;

public class RegexTermsEnum
extends FilteredTermsEnum {
    private RegexCapabilities.RegexMatcher regexImpl;
    private final BytesRef prefixRef;

    public RegexTermsEnum(TermsEnum tenum, Term term, RegexCapabilities regexCap) {
        super(tenum);
        String text = term.text();
        this.regexImpl = regexCap.compile(text);
        String pre = this.regexImpl.prefix();
        if (pre == null) {
            pre = "";
        }
        this.prefixRef = new BytesRef(pre);
        this.setInitialSeekTerm(this.prefixRef);
    }

    @Override
    protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
        if (StringHelper.startsWith(term, this.prefixRef)) {
            return this.regexImpl.match(term) ? FilteredTermsEnum.AcceptStatus.YES : FilteredTermsEnum.AcceptStatus.NO;
        }
        return FilteredTermsEnum.AcceptStatus.NO;
    }
}

