/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.xml.builders;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.TermsFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.xml.DOMUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.xml.FilterBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.xml.ParserException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.w3c.dom.Element;

public class TermsFilterBuilder
implements FilterBuilder {
    private final Analyzer analyzer;

    public TermsFilterBuilder(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public Filter getFilter(Element e) throws ParserException {
        ArrayList<BytesRef> terms = new ArrayList<BytesRef>();
        String text = DOMUtils.getNonBlankTextOrFail(e);
        String fieldName = DOMUtils.getAttributeWithInheritanceOrFail(e, "fieldName");
        TokenStream ts = null;
        try {
            ts = this.analyzer.tokenStream(fieldName, text);
            TermToBytesRefAttribute termAtt = ts.addAttribute(TermToBytesRefAttribute.class);
            BytesRef bytes = termAtt.getBytesRef();
            ts.reset();
            while (ts.incrementToken()) {
                termAtt.fillBytesRef();
                terms.add(BytesRef.deepCopyOf(bytes));
            }
            ts.end();
        }
        catch (IOException ioe) {
            try {
                throw new RuntimeException("Error constructing terms from index:" + ioe);
            }
            catch (Throwable throwable) {
                IOUtils.closeWhileHandlingException(ts);
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException(ts);
        return new TermsFilter(fieldName, terms);
    }
}

