/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.processors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.FuzzyQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.GroupQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.NoTokenFoundQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.QueryNodeImpl;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.QuotedFieldQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.RangeQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.TextableQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.TokenizedPhraseQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessorImpl;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.nodes.MultiPhraseQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.nodes.RegexpQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.nodes.StandardBooleanQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.nodes.WildcardQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;

public class AnalyzerQueryNodeProcessor
extends QueryNodeProcessorImpl {
    private Analyzer analyzer;
    private boolean positionIncrementsEnabled;
    private StandardQueryConfigHandler.Operator defaultOperator;

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        Analyzer analyzer = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ANALYZER);
        if (analyzer != null) {
            this.analyzer = analyzer;
            this.positionIncrementsEnabled = false;
            Boolean positionIncrementsEnabled = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.ENABLE_POSITION_INCREMENTS);
            StandardQueryConfigHandler.Operator defaultOperator = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR);
            StandardQueryConfigHandler.Operator operator = this.defaultOperator = defaultOperator != null ? defaultOperator : StandardQueryConfigHandler.Operator.OR;
            if (positionIncrementsEnabled != null) {
                this.positionIncrementsEnabled = positionIncrementsEnabled;
            }
            if (this.analyzer != null) {
                return super.process(queryTree);
            }
        }
        return queryTree;
    }

    @Override
    protected QueryNode postProcessNode(QueryNode node) throws QueryNodeException {
        block54: {
            if (!(node instanceof TextableQueryNode) || node instanceof WildcardQueryNode || node instanceof FuzzyQueryNode || node instanceof RegexpQueryNode || node.getParent() instanceof RangeQueryNode) break block54;
            FieldQueryNode fieldNode = (FieldQueryNode)node;
            String text = fieldNode.getTextAsString();
            String field = fieldNode.getFieldAsString();
            CachingTokenFilter buffer = null;
            PositionIncrementAttribute posIncrAtt = null;
            int numTokens = 0;
            int positionCount = 0;
            boolean severalTokensAtSamePosition = false;
            TokenStream source = null;
            try {
                source = this.analyzer.tokenStream(field, text);
                source.reset();
                buffer = new CachingTokenFilter(source);
                if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
                    posIncrAtt = buffer.getAttribute(PositionIncrementAttribute.class);
                }
                try {
                    while (buffer.incrementToken()) {
                        int positionIncrement;
                        ++numTokens;
                        int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                        if (positionIncrement != 0) {
                            positionCount += positionIncrement;
                            continue;
                        }
                        severalTokensAtSamePosition = true;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException(source);
                    throw throwable;
                }
            }
            IOUtils.closeWhileHandlingException(source);
            buffer.reset();
            if (!buffer.hasAttribute(CharTermAttribute.class)) {
                return new NoTokenFoundQueryNode();
            }
            CharTermAttribute termAtt = buffer.getAttribute(CharTermAttribute.class);
            if (numTokens == 0) {
                return new NoTokenFoundQueryNode();
            }
            if (numTokens == 1) {
                String term = null;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                }
                catch (IOException e) {
                    // empty catch block
                }
                fieldNode.setText(term);
                return fieldNode;
            }
            if (severalTokensAtSamePosition || !(node instanceof QuotedFieldQueryNode)) {
                if (positionCount == 1 || !(node instanceof QuotedFieldQueryNode)) {
                    if (positionCount == 1) {
                        LinkedList<QueryNode> children = new LinkedList<QueryNode>();
                        for (int i = 0; i < numTokens; ++i) {
                            String term = null;
                            try {
                                boolean hasNext = buffer.incrementToken();
                                assert (hasNext);
                                term = termAtt.toString();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                            children.add(new FieldQueryNode(field, term, -1, -1));
                        }
                        return new GroupQueryNode(new StandardBooleanQueryNode(children, positionCount == 1));
                    }
                    QueryNodeImpl q = new StandardBooleanQueryNode(Collections.emptyList(), false);
                    QueryNodeImpl currentQuery = null;
                    for (int i = 0; i < numTokens; ++i) {
                        String term = null;
                        try {
                            boolean hasNext = buffer.incrementToken();
                            assert (hasNext);
                            term = termAtt.toString();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (posIncrAtt != null && posIncrAtt.getPositionIncrement() == 0) {
                            if (!(currentQuery instanceof BooleanQueryNode)) {
                                FieldQueryNode t = currentQuery;
                                currentQuery = new StandardBooleanQueryNode(Collections.emptyList(), true);
                                ((BooleanQueryNode)currentQuery).add(t);
                            }
                            ((BooleanQueryNode)currentQuery).add(new FieldQueryNode(field, term, -1, -1));
                            continue;
                        }
                        if (currentQuery != null) {
                            if (this.defaultOperator == StandardQueryConfigHandler.Operator.OR) {
                                q.add(currentQuery);
                            } else {
                                q.add(new ModifierQueryNode(currentQuery, ModifierQueryNode.Modifier.MOD_REQ));
                            }
                        }
                        currentQuery = new FieldQueryNode(field, term, -1, -1);
                    }
                    if (this.defaultOperator == StandardQueryConfigHandler.Operator.OR) {
                        q.add(currentQuery);
                    } else {
                        q.add(new ModifierQueryNode(currentQuery, ModifierQueryNode.Modifier.MOD_REQ));
                    }
                    if (q instanceof BooleanQueryNode) {
                        q = new GroupQueryNode(q);
                    }
                    return q;
                }
                MultiPhraseQueryNode mpq = new MultiPhraseQueryNode();
                ArrayList<FieldQueryNode> multiTerms = new ArrayList<FieldQueryNode>();
                int position = -1;
                int termGroupCount = 0;
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    int positionIncrement = 1;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                        if (posIncrAtt != null) {
                            positionIncrement = posIncrAtt.getPositionIncrement();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (positionIncrement > 0 && multiTerms.size() > 0) {
                        for (FieldQueryNode termNode : multiTerms) {
                            if (this.positionIncrementsEnabled) {
                                termNode.setPositionIncrement(position);
                            } else {
                                termNode.setPositionIncrement(termGroupCount);
                            }
                            mpq.add(termNode);
                        }
                        ++termGroupCount;
                        multiTerms.clear();
                    }
                    position += positionIncrement;
                    multiTerms.add(new FieldQueryNode(field, term, -1, -1));
                }
                for (FieldQueryNode termNode : multiTerms) {
                    if (this.positionIncrementsEnabled) {
                        termNode.setPositionIncrement(position);
                    } else {
                        termNode.setPositionIncrement(termGroupCount);
                    }
                    mpq.add(termNode);
                }
                return mpq;
            }
            TokenizedPhraseQueryNode pq = new TokenizedPhraseQueryNode();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                FieldQueryNode newFieldNode = new FieldQueryNode(field, term, -1, -1);
                if (this.positionIncrementsEnabled) {
                    newFieldNode.setPositionIncrement(position += positionIncrement);
                } else {
                    newFieldNode.setPositionIncrement(i);
                }
                pq.add(newFieldNode);
            }
            return pq;
        }
        return node;
    }

    @Override
    protected QueryNode preProcessNode(QueryNode node) throws QueryNodeException {
        return node;
    }

    @Override
    protected List<QueryNode> setChildrenOrder(List<QueryNode> children) throws QueryNodeException {
        return children;
    }
}

