/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.builders;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.FieldQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.core.util.StringUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.builders.StandardQueryBuilder;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queryparser.flexible.standard.nodes.TermRangeQueryNode;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.TermRangeQuery;

public class TermRangeQueryNodeBuilder
implements StandardQueryBuilder {
    @Override
    public TermRangeQuery build(QueryNode queryNode) throws QueryNodeException {
        TermRangeQueryNode rangeNode = (TermRangeQueryNode)queryNode;
        FieldQueryNode upper = (FieldQueryNode)rangeNode.getUpperBound();
        FieldQueryNode lower = (FieldQueryNode)rangeNode.getLowerBound();
        String field = StringUtils.toString(rangeNode.getField());
        String lowerText = lower.getTextAsString();
        String upperText = upper.getTextAsString();
        if (lowerText.length() == 0) {
            lowerText = null;
        }
        if (upperText.length() == 0) {
            upperText = null;
        }
        TermRangeQuery rangeQuery = TermRangeQuery.newStringRange(field, lowerText, upperText, rangeNode.isLowerInclusive(), rangeNode.isUpperInclusive());
        MultiTermQuery.RewriteMethod method = (MultiTermQuery.RewriteMethod)queryNode.getTag("MultiTermRewriteMethodConfiguration");
        if (method != null) {
            rangeQuery.setRewriteMethod(method);
        }
        return rangeQuery;
    }
}

