/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.FunctionValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries.function.valuesource.ConstIntDocValues;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;

public class MaxDocValueSource
extends ValueSource {
    public String name() {
        return "maxdoc";
    }

    @Override
    public String description() {
        return this.name() + "()";
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        context.put("searcher", searcher);
    }

    @Override
    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        return new ConstIntDocValues(searcher.getIndexReader().maxDoc(), this);
    }

    @Override
    public boolean equals(Object o) {
        return this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

