/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.AtomicReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BitsFilteredDocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Filter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.FixedBitSet;

public class ChainedFilter
extends Filter {
    public static final int OR = 0;
    public static final int AND = 1;
    public static final int ANDNOT = 2;
    public static final int XOR = 3;
    public static final int DEFAULT = 0;
    private Filter[] chain = null;
    private int[] logicArray;
    private int logic = -1;

    public ChainedFilter(Filter[] chain) {
        this.chain = chain;
    }

    public ChainedFilter(Filter[] chain, int[] logicArray) {
        this.chain = chain;
        this.logicArray = logicArray;
    }

    public ChainedFilter(Filter[] chain, int logic) {
        this.chain = chain;
        this.logic = logic;
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        int[] index = new int[]{0};
        if (this.logic != -1) {
            return BitsFilteredDocIdSet.wrap(this.getDocIdSet(context, this.logic, index), acceptDocs);
        }
        if (this.logicArray != null) {
            return BitsFilteredDocIdSet.wrap(this.getDocIdSet(context, this.logicArray, index), acceptDocs);
        }
        return BitsFilteredDocIdSet.wrap(this.getDocIdSet(context, 0, index), acceptDocs);
    }

    private DocIdSetIterator getDISI(Filter filter, AtomicReaderContext context) throws IOException {
        DocIdSet docIdSet = filter.getDocIdSet(context, null);
        if (docIdSet == null) {
            return DocIdSetIterator.empty();
        }
        DocIdSetIterator iter = docIdSet.iterator();
        if (iter == null) {
            return DocIdSetIterator.empty();
        }
        return iter;
    }

    private FixedBitSet initialResult(AtomicReaderContext context, int logic, int[] index) throws IOException {
        AtomicReader reader = context.reader();
        FixedBitSet result = new FixedBitSet(reader.maxDoc());
        if (logic == 1) {
            result.or(this.getDISI(this.chain[index[0]], context));
            index[0] = index[0] + 1;
        } else if (logic == 2) {
            result.or(this.getDISI(this.chain[index[0]], context));
            result.flip(0, reader.maxDoc());
            index[0] = index[0] + 1;
        }
        return result;
    }

    private DocIdSet getDocIdSet(AtomicReaderContext context, int logic, int[] index) throws IOException {
        FixedBitSet result = this.initialResult(context, logic, index);
        while (index[0] < this.chain.length) {
            this.doChain(result, logic, this.chain[index[0]].getDocIdSet(context, null));
            index[0] = index[0] + 1;
        }
        return result;
    }

    private DocIdSet getDocIdSet(AtomicReaderContext context, int[] logic, int[] index) throws IOException {
        if (logic.length != this.chain.length) {
            throw new IllegalArgumentException("Invalid number of elements in logic array");
        }
        FixedBitSet result = this.initialResult(context, logic[0], index);
        while (index[0] < this.chain.length) {
            this.doChain(result, logic[index[0]], this.chain[index[0]].getDocIdSet(context, null));
            index[0] = index[0] + 1;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ChainedFilter: [");
        for (Filter aChain : this.chain) {
            sb.append(aChain);
            sb.append(' ');
        }
        sb.append(']');
        return sb.toString();
    }

    private void doChain(FixedBitSet result, int logic, DocIdSet dis) throws IOException {
        if (dis instanceof FixedBitSet) {
            switch (logic) {
                case 0: {
                    result.or((FixedBitSet)dis);
                    break;
                }
                case 1: {
                    result.and((FixedBitSet)dis);
                    break;
                }
                case 2: {
                    result.andNot((FixedBitSet)dis);
                    break;
                }
                case 3: {
                    result.xor((FixedBitSet)dis);
                    break;
                }
                default: {
                    this.doChain(result, 0, dis);
                    break;
                }
            }
        } else {
            DocIdSetIterator disi;
            if (dis == null) {
                disi = DocIdSetIterator.empty();
            } else {
                disi = dis.iterator();
                if (disi == null) {
                    disi = DocIdSetIterator.empty();
                }
            }
            switch (logic) {
                case 0: {
                    result.or(disi);
                    break;
                }
                case 1: {
                    result.and(disi);
                    break;
                }
                case 2: {
                    result.andNot(disi);
                    break;
                }
                case 3: {
                    result.xor(disi);
                    break;
                }
                default: {
                    this.doChain(result, 0, dis);
                }
            }
        }
    }
}

