/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.queries;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.search.Weight;

public class BoostingQuery
extends Query {
    private final float boost;
    private final Query match;
    private final Query context;

    public BoostingQuery(Query match, Query context, float boost) {
        this.match = match;
        this.context = context.clone();
        this.boost = boost;
        this.context.setBoost(0.0f);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        BooleanQuery result = new BooleanQuery(){

            @Override
            public Weight createWeight(IndexSearcher searcher) throws IOException {
                return new BooleanQuery.BooleanWeight(searcher, false){

                    @Override
                    public float coord(int overlap, int max) {
                        switch (overlap) {
                            case 1: {
                                return 1.0f;
                            }
                            case 2: {
                                return BoostingQuery.this.boost;
                            }
                        }
                        return 0.0f;
                    }
                };
            }
        };
        result.add(this.match, BooleanClause.Occur.MUST);
        result.add(this.context, BooleanClause.Occur.SHOULD);
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.boost);
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.match == null ? 0 : this.match.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BoostingQuery other = (BoostingQuery)obj;
        if (Float.floatToIntBits(this.boost) != Float.floatToIntBits(other.boost)) {
            return false;
        }
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.match == null ? other.match != null : !this.match.equals(other.match));
    }

    @Override
    public String toString(String field) {
        return this.match.toString(field) + "/" + this.context.toString(field);
    }
}

