/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInvertState;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentWriteState;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.TermsHashPerField;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.ByteBlockPool;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IntBlockPool;

abstract class TermsHash {
    final TermsHash nextTermsHash;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    ByteBlockPool termBytePool;
    final Counter bytesUsed;
    final DocumentsWriterPerThread.DocState docState;
    final boolean trackAllocations;

    TermsHash(DocumentsWriterPerThread docWriter, boolean trackAllocations, TermsHash nextTermsHash) {
        this.docState = docWriter.docState;
        this.trackAllocations = trackAllocations;
        this.nextTermsHash = nextTermsHash;
        this.bytesUsed = trackAllocations ? docWriter.bytesUsed : Counter.newCounter();
        this.intPool = new IntBlockPool(docWriter.intBlockAllocator);
        this.bytePool = new ByteBlockPool(docWriter.byteBlockAllocator);
        if (nextTermsHash != null) {
            this.termBytePool = this.bytePool;
            nextTermsHash.termBytePool = this.bytePool;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        try {
            this.reset();
        }
        finally {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
        }
    }

    void reset() {
        this.intPool.reset(false, false);
        this.bytePool.reset(false, false);
    }

    void flush(Map<String, TermsHashPerField> fieldsToFlush, SegmentWriteState state) throws IOException {
        if (this.nextTermsHash != null) {
            HashMap<String, TermsHashPerField> nextChildFields = new HashMap<String, TermsHashPerField>();
            for (Map.Entry<String, TermsHashPerField> entry : fieldsToFlush.entrySet()) {
                nextChildFields.put(entry.getKey(), entry.getValue().nextPerField);
            }
            this.nextTermsHash.flush(nextChildFields, state);
        }
    }

    abstract TermsHashPerField addField(FieldInvertState var1, FieldInfo var2);

    void finishDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.finishDocument();
        }
    }

    void startDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.startDocument();
        }
    }
}

