/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.Codec;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.lucene3x.Lucene3xCodec;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.lucene3x.Lucene3xSegmentInfoReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexNotFoundException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.MergePolicy;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentCommitInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;

public final class SegmentInfos
implements Cloneable,
Iterable<SegmentCommitInfo> {
    public static final int VERSION_40 = 0;
    public static final int VERSION_46 = 1;
    public static final int VERSION_48 = 2;
    public static final int VERSION_49 = 3;
    private static final int FORMAT_SEGMENTS_GEN_47 = -2;
    private static final int FORMAT_SEGMENTS_GEN_CHECKSUM = -3;
    private static final int FORMAT_SEGMENTS_GEN_START = -2;
    public static final int FORMAT_SEGMENTS_GEN_CURRENT = -3;
    public int counter;
    public long version;
    private long generation;
    private long lastGeneration;
    public Map<String, String> userData = Collections.emptyMap();
    private List<SegmentCommitInfo> segments = new ArrayList<SegmentCommitInfo>();
    private static PrintStream infoStream = null;
    IndexOutput pendingSegnOutput;
    private static final String SEGMENT_INFO_UPGRADE_CODEC = "SegmentInfo3xUpgrade";
    private static final int SEGMENT_INFO_UPGRADE_VERSION = 0;
    private static int defaultGenLookaheadCount = 10;

    public SegmentCommitInfo info(int i) {
        return this.segments.get(i);
    }

    public static long getLastCommitGeneration(String[] files) {
        if (files == null) {
            return -1L;
        }
        long max = -1L;
        for (String file : files) {
            long gen;
            if (!file.startsWith("segments") || file.equals("segments.gen") || (gen = SegmentInfos.generationFromSegmentsFileName(file)) <= max) continue;
            max = gen;
        }
        return max;
    }

    public static long getLastCommitGeneration(Directory directory) throws IOException {
        try {
            return SegmentInfos.getLastCommitGeneration(directory.listAll());
        }
        catch (NoSuchDirectoryException nsde) {
            return -1L;
        }
    }

    public static String getLastCommitSegmentsFileName(String[] files) {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(files));
    }

    public static String getLastCommitSegmentsFileName(Directory directory) throws IOException {
        return IndexFileNames.fileNameFromGeneration("segments", "", SegmentInfos.getLastCommitGeneration(directory));
    }

    public String getSegmentsFileName() {
        return IndexFileNames.fileNameFromGeneration("segments", "", this.lastGeneration);
    }

    public static long generationFromSegmentsFileName(String fileName) {
        if (fileName.equals("segments")) {
            return 0L;
        }
        if (fileName.startsWith("segments")) {
            return Long.parseLong(fileName.substring(1 + "segments".length()), 36);
        }
        throw new IllegalArgumentException("fileName \"" + fileName + "\" is not a segments file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSegmentsGen(Directory dir, long generation) {
        try {
            IndexOutput genOutput = dir.createOutput("segments.gen", IOContext.READONCE);
            try {
                genOutput.writeInt(-3);
                genOutput.writeLong(generation);
                genOutput.writeLong(generation);
                CodecUtil.writeFooter(genOutput);
            }
            finally {
                genOutput.close();
                dir.sync(Collections.singleton("segments.gen"));
            }
        }
        catch (Throwable t) {
            IOUtils.deleteFilesIgnoringExceptions(dir, "segments.gen");
        }
    }

    public String getNextSegmentFileName() {
        long nextGeneration = this.generation == -1L ? 1L : this.generation + 1L;
        return IndexFileNames.fileNameFromGeneration("segments", "", nextGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void read(Directory directory, String segmentFileName) throws IOException {
        block25: {
            ChecksumIndexInput input;
            block24: {
                boolean success = false;
                this.clear();
                this.lastGeneration = this.generation = SegmentInfos.generationFromSegmentsFileName(segmentFileName);
                input = directory.openChecksumInput(segmentFileName, IOContext.READ);
                try {
                    int actualFormat;
                    int format = input.readInt();
                    long totalDocs = 0L;
                    if (format == 1071082519) {
                        actualFormat = CodecUtil.checkHeaderNoMagic(input, "segments", 0, 3);
                        this.version = input.readLong();
                        this.counter = input.readInt();
                        int numSegments = input.readInt();
                        if (numSegments < 0) {
                            throw new CorruptIndexException("invalid segment count: " + numSegments + " (resource: " + input + ")");
                        }
                        for (int seg = 0; seg < numSegments; ++seg) {
                            String segName = input.readString();
                            Codec codec = Codec.forName(input.readString());
                            SegmentInfo info = codec.segmentInfoFormat().getSegmentInfoReader().read(directory, segName, IOContext.READ);
                            info.setCodec(codec);
                            totalDocs += (long)info.getDocCount();
                            long delGen = input.readLong();
                            int delCount = input.readInt();
                            if (delCount < 0 || delCount > info.getDocCount()) {
                                throw new CorruptIndexException("invalid deletion count: " + delCount + " vs docCount=" + info.getDocCount() + " (resource: " + input + ")");
                            }
                            long fieldInfosGen = -1L;
                            if (actualFormat >= 1) {
                                fieldInfosGen = input.readLong();
                            }
                            long dvGen = -1L;
                            dvGen = actualFormat >= 3 ? input.readLong() : fieldInfosGen;
                            SegmentCommitInfo siPerCommit = new SegmentCommitInfo(info, delCount, delGen, fieldInfosGen, dvGen);
                            if (actualFormat >= 1) {
                                int i;
                                if (actualFormat < 3) {
                                    Map<Long, Set<String>> genUpdatesFiles;
                                    int numGensUpdatesFiles = input.readInt();
                                    if (numGensUpdatesFiles == 0) {
                                        genUpdatesFiles = Collections.emptyMap();
                                    } else {
                                        genUpdatesFiles = new HashMap(numGensUpdatesFiles);
                                        for (i = 0; i < numGensUpdatesFiles; ++i) {
                                            genUpdatesFiles.put(input.readLong(), input.readStringSet());
                                        }
                                    }
                                    siPerCommit.setGenUpdatesFiles(genUpdatesFiles);
                                } else {
                                    Map<Integer, Set<String>> dvUpdateFiles;
                                    siPerCommit.setFieldInfosFiles(input.readStringSet());
                                    int numDVFields = input.readInt();
                                    if (numDVFields == 0) {
                                        dvUpdateFiles = Collections.emptyMap();
                                    } else {
                                        dvUpdateFiles = new HashMap(numDVFields);
                                        for (i = 0; i < numDVFields; ++i) {
                                            dvUpdateFiles.put(input.readInt(), input.readStringSet());
                                        }
                                    }
                                    siPerCommit.setDocValuesUpdatesFiles(dvUpdateFiles);
                                }
                            }
                            this.add(siPerCommit);
                        }
                        this.userData = input.readStringStringMap();
                    } else {
                        actualFormat = -1;
                        Lucene3xSegmentInfoReader.readLegacyInfos(this, directory, input, format);
                        Codec codec = Codec.forName("Lucene3x");
                        for (SegmentCommitInfo info : this) {
                            info.info.setCodec(codec);
                            totalDocs += (long)info.info.getDocCount();
                        }
                    }
                    if (actualFormat >= 2) {
                        CodecUtil.checkFooter(input);
                    } else {
                        long checksumThen;
                        long checksumNow = input.getChecksum();
                        if (checksumNow != (checksumThen = input.readLong())) {
                            throw new CorruptIndexException("checksum mismatch in segments file (resource: " + input + ")");
                        }
                        CodecUtil.checkEOF(input);
                    }
                    if (totalDocs > (long)IndexWriter.getActualMaxDocs()) {
                        throw new CorruptIndexException("Too many documents: an index cannot exceed " + IndexWriter.getActualMaxDocs() + " but readers have total maxDoc=" + totalDocs + " (resource: " + input + ")");
                    }
                    success = true;
                    if (success) break block24;
                    this.clear();
                }
                catch (Throwable throwable) {
                    if (!success) {
                        this.clear();
                        IOUtils.closeWhileHandlingException(input);
                    } else {
                        input.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(input);
                break block25;
            }
            input.close();
        }
    }

    public final void read(Directory directory) throws IOException {
        this.lastGeneration = -1L;
        this.generation = -1L;
        new FindSegmentsFile(directory){

            @Override
            protected Object doBody(String segmentFileName) throws IOException {
                SegmentInfos.this.read(this.directory, segmentFileName);
                return null;
            }
        }.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void write(Directory directory) throws IOException {
        String segmentsFileName = this.getNextSegmentFileName();
        this.generation = this.generation == -1L ? 1L : ++this.generation;
        IndexOutput segnOutput = null;
        boolean success = false;
        HashSet<String> upgradedSIFiles = new HashSet<String>();
        try {
            segnOutput = directory.createOutput(segmentsFileName, IOContext.DEFAULT);
            CodecUtil.writeHeader(segnOutput, "segments", 3);
            segnOutput.writeLong(this.version);
            segnOutput.writeInt(this.counter);
            segnOutput.writeInt(this.size());
            for (SegmentCommitInfo siPerCommit : this) {
                SegmentInfo si = siPerCommit.info;
                segnOutput.writeString(si.name);
                segnOutput.writeString(si.getCodec().getName());
                segnOutput.writeLong(siPerCommit.getDelGen());
                int delCount = siPerCommit.getDelCount();
                if (delCount < 0 || delCount > si.getDocCount()) {
                    throw new IllegalStateException("cannot write segment: invalid docCount segment=" + si.name + " docCount=" + si.getDocCount() + " delCount=" + delCount);
                }
                segnOutput.writeInt(delCount);
                segnOutput.writeLong(siPerCommit.getFieldInfosGen());
                segnOutput.writeLong(siPerCommit.getDocValuesGen());
                segnOutput.writeStringSet(siPerCommit.getFieldInfosFiles());
                Map<Integer, Set<String>> dvUpdatesFiles = siPerCommit.getDocValuesUpdatesFiles();
                segnOutput.writeInt(dvUpdatesFiles.size());
                for (Map.Entry<Integer, Set<String>> e : dvUpdatesFiles.entrySet()) {
                    segnOutput.writeInt(e.getKey());
                    segnOutput.writeStringSet(e.getValue());
                }
                assert (si.dir == directory);
                Version version = si.getVersion();
                if (version != null && version.onOrAfter(Version.LUCENE_4_0_0_ALPHA)) continue;
                if (!(si.getCodec() instanceof Lucene3xCodec)) {
                    throw new IllegalStateException("cannot write 3x SegmentInfo unless codec is Lucene3x (got: " + si.getCodec() + ")");
                }
                if (SegmentInfos.segmentWasUpgraded(directory, si)) continue;
                String markerFileName = IndexFileNames.segmentFileName(si.name, "upgraded", "si");
                si.addFile(markerFileName);
                String segmentFileName = SegmentInfos.write3xInfo(directory, si, IOContext.DEFAULT);
                upgradedSIFiles.add(segmentFileName);
                directory.sync(Collections.singletonList(segmentFileName));
                try (IndexOutput out = directory.createOutput(markerFileName, IOContext.DEFAULT);){
                    CodecUtil.writeHeader(out, SEGMENT_INFO_UPGRADE_CODEC, 0);
                }
                upgradedSIFiles.add(markerFileName);
                directory.sync(Collections.singletonList(markerFileName));
            }
            segnOutput.writeStringStringMap(this.userData);
            this.pendingSegnOutput = segnOutput;
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(segnOutput);
            for (String fileName : upgradedSIFiles) {
                IOUtils.deleteFilesIgnoringExceptions(directory, fileName);
            }
            IOUtils.deleteFilesIgnoringExceptions(directory, segmentsFileName);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean segmentWasUpgraded(Directory directory, SegmentInfo si) {
        IndexInput in;
        block8: {
            boolean bl;
            block9: {
                String markerFileName = IndexFileNames.segmentFileName(si.name, "upgraded", "si");
                if (!si.files().contains(markerFileName)) {
                    return false;
                }
                in = null;
                try {
                    in = directory.openInput(markerFileName, IOContext.READONCE);
                    if (CodecUtil.checkHeader(in, SEGMENT_INFO_UPGRADE_CODEC, 0, 0) != 0) break block8;
                    bl = true;
                    if (in == null) break block9;
                }
                catch (IOException ioe) {
                    if (in != null) {
                        IOUtils.closeWhileHandlingException(in);
                    }
                    catch (Throwable throwable) {
                        if (in != null) {
                            IOUtils.closeWhileHandlingException(in);
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeWhileHandlingException(in);
            }
            return bl;
        }
        if (in != null) {
            IOUtils.closeWhileHandlingException(in);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static String write3xInfo(Directory dir, SegmentInfo si, IOContext context) throws IOException {
        if (!(si.getCodec() instanceof Lucene3xCodec)) {
            throw new IllegalStateException("cannot write 3x SegmentInfo unless codec is Lucene3x (got: " + si.getCodec() + ")");
        }
        String fileName = IndexFileNames.segmentFileName(si.name, "", "si");
        si.addFile(fileName);
        boolean success = false;
        IndexOutput output = dir.createOutput(fileName, context);
        try {
            CodecUtil.writeHeader(output, "Lucene3xSegmentInfo", 0);
            output.writeString(si.getVersion().toString());
            output.writeInt(si.getDocCount());
            output.writeStringStringMap(si.attributes());
            output.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
            output.writeStringStringMap(si.getDiagnostics());
            output.writeStringSet(si.files());
            output.close();
            return fileName;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(output);
            try {
                si.dir.deleteFile(fileName);
                throw throwable;
            }
            catch (Throwable t) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public SegmentInfos clone() {
        return this.clone(false);
    }

    SegmentInfos clone(boolean cloneSegmentInfo) {
        try {
            SegmentInfos sis = (SegmentInfos)super.clone();
            sis.segments = new ArrayList<SegmentCommitInfo>(this.size());
            for (SegmentCommitInfo info : this) {
                assert (info.info.getCodec() != null);
                sis.add(info.clone(cloneSegmentInfo));
            }
            sis.userData = new HashMap<String, String>(this.userData);
            return sis;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("should not happen", e);
        }
    }

    public long getVersion() {
        return this.version;
    }

    public long getGeneration() {
        return this.generation;
    }

    public long getLastGeneration() {
        return this.lastGeneration;
    }

    public static void setInfoStream(PrintStream infoStream) {
        SegmentInfos.infoStream = infoStream;
    }

    public static void setDefaultGenLookaheadCount(int count) {
        defaultGenLookaheadCount = count;
    }

    public static int getDefaultGenLookahedCount() {
        return defaultGenLookaheadCount;
    }

    public static PrintStream getInfoStream() {
        return infoStream;
    }

    private static void message(String message) {
        infoStream.println("SIS [" + Thread.currentThread().getName() + "]: " + message);
    }

    void updateGeneration(SegmentInfos other) {
        this.lastGeneration = other.lastGeneration;
        this.generation = other.generation;
    }

    void setGeneration(long generation) {
        this.generation = generation;
        this.lastGeneration = generation;
    }

    final void rollbackCommit(Directory dir) {
        if (this.pendingSegnOutput != null) {
            IOUtils.closeWhileHandlingException(this.pendingSegnOutput);
            this.pendingSegnOutput = null;
            String segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
            IOUtils.deleteFilesIgnoringExceptions(dir, segmentFileName);
        }
    }

    final void prepareCommit(Directory dir) throws IOException {
        if (this.pendingSegnOutput != null) {
            throw new IllegalStateException("prepareCommit was already called");
        }
        this.write(dir);
    }

    public Collection<String> files(Directory dir, boolean includeSegmentsFile) throws IOException {
        String segmentFileName;
        HashSet<String> files = new HashSet<String>();
        if (includeSegmentsFile && (segmentFileName = this.getSegmentsFileName()) != null) {
            files.add(segmentFileName);
        }
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            SegmentCommitInfo info = this.info(i);
            assert (info.info.dir == dir);
            if (info.info.dir != dir) continue;
            files.addAll(info.files());
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final String finishCommit(Directory dir) throws IOException {
        String fileName;
        block18: {
            if (this.pendingSegnOutput == null) {
                throw new IllegalStateException("prepareCommit was not called");
            }
            boolean success = false;
            try {
                CodecUtil.writeFooter(this.pendingSegnOutput);
                success = true;
            }
            finally {
                if (!success) {
                    this.rollbackCommit(dir);
                } else {
                    success = false;
                    try {
                        this.pendingSegnOutput.close();
                        success = true;
                    }
                    finally {
                        if (!success) {
                            this.rollbackCommit(dir);
                        } else {
                            this.pendingSegnOutput = null;
                        }
                    }
                }
            }
            fileName = IndexFileNames.fileNameFromGeneration("segments", "", this.generation);
            success = false;
            try {
                dir.sync(Collections.singleton(fileName));
                success = true;
                if (success) break block18;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
                }
                throw throwable;
            }
            IOUtils.deleteFilesIgnoringExceptions(dir, fileName);
        }
        this.lastGeneration = this.generation;
        SegmentInfos.writeSegmentsGen(dir, this.generation);
        return fileName;
    }

    final void commit(Directory dir) throws IOException {
        this.prepareCommit(dir);
        this.finishCommit(dir);
    }

    public String toString(Directory directory) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getSegmentsFileName()).append(": ");
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                buffer.append(' ');
            }
            SegmentCommitInfo info = this.info(i);
            buffer.append(info.toString(directory, 0));
        }
        return buffer.toString();
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    void setUserData(Map<String, String> data) {
        this.userData = data == null ? Collections.emptyMap() : data;
    }

    void replace(SegmentInfos other) {
        this.rollbackSegmentInfos(other.asList());
        this.lastGeneration = other.lastGeneration;
    }

    public int totalDocCount() {
        long count = 0L;
        for (SegmentCommitInfo info : this) {
            count += (long)info.info.getDocCount();
        }
        assert (count <= (long)IndexWriter.getActualMaxDocs());
        return (int)count;
    }

    public void changed() {
        ++this.version;
    }

    void applyMergeChanges(MergePolicy.OneMerge merge, boolean dropSegment) {
        HashSet<SegmentCommitInfo> mergedAway = new HashSet<SegmentCommitInfo>(merge.segments);
        boolean inserted = false;
        int newSegIdx = 0;
        int cnt = this.segments.size();
        for (int segIdx = 0; segIdx < cnt; ++segIdx) {
            assert (segIdx >= newSegIdx);
            SegmentCommitInfo info = this.segments.get(segIdx);
            if (mergedAway.contains(info)) {
                if (inserted || dropSegment) continue;
                this.segments.set(segIdx, merge.info);
                inserted = true;
                ++newSegIdx;
                continue;
            }
            this.segments.set(newSegIdx, info);
            ++newSegIdx;
        }
        this.segments.subList(newSegIdx, this.segments.size()).clear();
        if (!inserted && !dropSegment) {
            this.segments.add(0, merge.info);
        }
    }

    List<SegmentCommitInfo> createBackupSegmentInfos() {
        ArrayList<SegmentCommitInfo> list = new ArrayList<SegmentCommitInfo>(this.size());
        for (SegmentCommitInfo info : this) {
            assert (info.info.getCodec() != null);
            list.add(info.clone());
        }
        return list;
    }

    void rollbackSegmentInfos(List<SegmentCommitInfo> infos) {
        this.clear();
        this.addAll(infos);
    }

    @Override
    public Iterator<SegmentCommitInfo> iterator() {
        return this.asList().iterator();
    }

    public List<SegmentCommitInfo> asList() {
        return Collections.unmodifiableList(this.segments);
    }

    public int size() {
        return this.segments.size();
    }

    public void add(SegmentCommitInfo si) {
        this.segments.add(si);
    }

    public void addAll(Iterable<SegmentCommitInfo> sis) {
        for (SegmentCommitInfo si : sis) {
            this.add(si);
        }
    }

    public void clear() {
        this.segments.clear();
    }

    public void remove(SegmentCommitInfo si) {
        this.segments.remove(si);
    }

    void remove(int index) {
        this.segments.remove(index);
    }

    boolean contains(SegmentCommitInfo si) {
        return this.segments.contains(si);
    }

    int indexOf(SegmentCommitInfo si) {
        return this.segments.indexOf(si);
    }

    public static abstract class FindSegmentsFile {
        final Directory directory;

        public FindSegmentsFile(Directory directory) {
            this.directory = directory;
        }

        public Object run() throws IOException {
            return this.run(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object run(IndexCommit commit) throws IOException {
            if (commit != null) {
                if (this.directory == commit.getDirectory()) return this.doBody(commit.getSegmentsFileName());
                throw new IOException("the specified commit does not match the specified Directory");
            }
            String segmentFileName = null;
            long lastGen = -1L;
            long gen = 0L;
            int genLookaheadCount = 0;
            IOException exc = null;
            int retryCount = 0;
            boolean useFirstMethod = true;
            while (true) {
                if (useFirstMethod) {
                    ChecksumIndexInput genInput;
                    long genB;
                    long genA;
                    Object[] files;
                    block33: {
                        files = null;
                        genA = -1L;
                        files = this.directory.listAll();
                        if (files != null) {
                            genA = SegmentInfos.getLastCommitGeneration((String[])files);
                        }
                        if (infoStream != null) {
                            SegmentInfos.message("directory listing genA=" + genA);
                        }
                        genB = -1L;
                        genInput = null;
                        try {
                            genInput = this.directory.openChecksumInput("segments.gen", IOContext.READONCE);
                        }
                        catch (IOException e) {
                            if (infoStream == null) break block33;
                            SegmentInfos.message("segments.gen open: IOException " + e);
                        }
                    }
                    if (genInput != null) {
                        try {
                            int version = genInput.readInt();
                            if (version != -2 && version != -3) throw new IndexFormatTooNewException(genInput, version, -2, -3);
                            long gen0 = genInput.readLong();
                            long gen1 = genInput.readLong();
                            if (infoStream != null) {
                                SegmentInfos.message("fallback check: " + gen0 + "; " + gen1);
                            }
                            if (version == -3) {
                                CodecUtil.checkFooter(genInput);
                            } else {
                                CodecUtil.checkEOF(genInput);
                            }
                            if (gen0 == gen1) {
                                genB = gen0;
                            }
                        }
                        catch (IOException err2) {
                            if (err2 instanceof CorruptIndexException) {
                                throw err2;
                            }
                        }
                        finally {
                            genInput.close();
                        }
                    }
                    if (infoStream != null) {
                        SegmentInfos.message("segments.gen check: genB=" + genB);
                    }
                    if ((gen = Math.max(genA, genB)) == -1L) {
                        throw new IndexNotFoundException("no segments* file found in " + this.directory + ": files: " + Arrays.toString(files));
                    }
                }
                if (useFirstMethod && lastGen == gen && retryCount >= 2) {
                    useFirstMethod = false;
                }
                if (!useFirstMethod) {
                    if (genLookaheadCount >= defaultGenLookaheadCount) throw exc;
                    ++gen;
                    ++genLookaheadCount;
                    if (infoStream != null) {
                        SegmentInfos.message("look ahead increment gen to " + gen);
                    }
                } else {
                    retryCount = lastGen == gen ? ++retryCount : 0;
                }
                lastGen = gen;
                segmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen);
                try {
                    Object v = this.doBody(segmentFileName);
                    if (infoStream == null) return v;
                    SegmentInfos.message("success on " + segmentFileName);
                    return v;
                }
                catch (IOException err) {
                    boolean prevExists;
                    if (exc == null) {
                        exc = err;
                    }
                    if (infoStream != null) {
                        SegmentInfos.message("primary Exception on '" + segmentFileName + "': " + err + "'; will retry: retryCount=" + retryCount + "; gen = " + gen);
                    }
                    if (gen <= 1L || !useFirstMethod || retryCount != 1) continue;
                    String prevSegmentFileName = IndexFileNames.fileNameFromGeneration("segments", "", gen - 1L);
                    try {
                        this.directory.openInput(prevSegmentFileName, IOContext.DEFAULT).close();
                        prevExists = true;
                    }
                    catch (IOException ioe) {
                        prevExists = false;
                    }
                    if (!prevExists) continue;
                    if (infoStream != null) {
                        SegmentInfos.message("fallback to prior segment file '" + prevSegmentFileName + "'");
                    }
                    try {
                        Object v = this.doBody(prevSegmentFileName);
                        if (infoStream == null) return v;
                        SegmentInfos.message("success on fallback " + prevSegmentFileName);
                        return v;
                    }
                    catch (IOException err2) {
                        if (infoStream == null) continue;
                        SegmentInfos.message("secondary Exception on '" + prevSegmentFileName + "': " + err2 + "'; will retry");
                        continue;
                    }
                }
                break;
            }
        }

        protected abstract Object doBody(String var1) throws IOException;
    }
}

