/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.SegmentInfoWriter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;

public class Lucene46SegmentInfoWriter
extends SegmentInfoWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Directory dir, SegmentInfo si, FieldInfos fis, IOContext ioContext) throws IOException {
        block6: {
            IndexOutput output;
            block5: {
                String fileName = IndexFileNames.segmentFileName(si.name, "", "si");
                si.addFile(fileName);
                output = dir.createOutput(fileName, ioContext);
                boolean success = false;
                try {
                    CodecUtil.writeHeader(output, "Lucene46SegmentInfo", 1);
                    Version version = si.getVersion();
                    if (version.major < 3 || version.major > 4) {
                        throw new IllegalArgumentException("invalid major version: should be 3 or 4 but got: " + version.major + " segment=" + si);
                    }
                    output.writeString(version.toString());
                    output.writeInt(si.getDocCount());
                    output.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
                    output.writeStringStringMap(si.getDiagnostics());
                    output.writeStringSet(si.files());
                    CodecUtil.writeFooter(output);
                    success = true;
                    if (success) break block5;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(output);
                        IOUtils.deleteFilesIgnoringExceptions(si.dir, fileName);
                    } else {
                        output.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(output);
                IOUtils.deleteFilesIgnoringExceptions(si.dir, fileName);
                break block6;
            }
            output.close();
        }
    }
}

