/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.SegmentInfoReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.SegmentInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;

public class Lucene46SegmentInfoReader
extends SegmentInfoReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, IOContext context) throws IOException {
        SegmentInfo segmentInfo;
        block10: {
            ChecksumIndexInput input;
            block9: {
                String fileName = IndexFileNames.segmentFileName(segment, "", "si");
                input = dir.openChecksumInput(fileName, context);
                boolean success = false;
                try {
                    Version version;
                    int codecVersion = CodecUtil.checkHeader(input, "Lucene46SegmentInfo", 0, 1);
                    try {
                        version = Version.parse(input.readString());
                    }
                    catch (ParseException pe) {
                        throw new CorruptIndexException("unable to parse version string (resource=" + input + "): " + pe.getMessage(), pe);
                    }
                    int docCount = input.readInt();
                    if (docCount < 0) {
                        throw new CorruptIndexException("invalid docCount: " + docCount + " (resource=" + input + ")");
                    }
                    boolean isCompoundFile = input.readByte() == 1;
                    Map<String, String> diagnostics = input.readStringStringMap();
                    Set<String> files = input.readStringSet();
                    if (codecVersion >= 1) {
                        CodecUtil.checkFooter(input);
                    } else {
                        CodecUtil.checkEOF(input);
                    }
                    SegmentInfo si = new SegmentInfo(dir, version, segment, docCount, isCompoundFile, null, diagnostics);
                    si.setFiles(files);
                    success = true;
                    segmentInfo = si;
                    if (success) break block9;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(input);
                    } else {
                        input.close();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(input);
                break block10;
            }
            input.close();
        }
        return segmentInfo;
    }
}

