/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.FieldInfosReader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.FieldInfos;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.IndexFileNames;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.ChecksumIndexInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.IOUtils;

final class Lucene46FieldInfosReader
extends FieldInfosReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldInfos read(Directory directory, String segmentName, String segmentSuffix, IOContext context) throws IOException {
        FieldInfos fieldInfos;
        block9: {
            ChecksumIndexInput input;
            block8: {
                String fileName = IndexFileNames.segmentFileName(segmentName, segmentSuffix, "fnm");
                input = directory.openChecksumInput(fileName, context);
                boolean success = false;
                try {
                    int codecVersion = CodecUtil.checkHeader(input, "Lucene46FieldInfos", 0, 2);
                    int size = input.readVInt();
                    FieldInfo[] infos = new FieldInfo[size];
                    for (int i = 0; i < size; ++i) {
                        boolean storePayloads;
                        String name = input.readString();
                        int fieldNumber = input.readVInt();
                        if (fieldNumber < 0) {
                            throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber + " (resource=" + input + ")");
                        }
                        byte bits = input.readByte();
                        boolean isIndexed = (bits & 1) != 0;
                        boolean storeTermVector = (bits & 2) != 0;
                        boolean omitNorms = (bits & 0x10) != 0;
                        boolean bl = storePayloads = (bits & 0x20) != 0;
                        FieldInfo.IndexOptions indexOptions = !isIndexed ? null : ((bits & 0x40) != 0 ? FieldInfo.IndexOptions.DOCS_ONLY : ((bits & 0xFFFFFF80) != 0 ? FieldInfo.IndexOptions.DOCS_AND_FREQS : ((bits & 4) != 0 ? FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS)));
                        byte val = input.readByte();
                        FieldInfo.DocValuesType docValuesType = Lucene46FieldInfosReader.getDocValuesType(input, (byte)(val & 0xF));
                        FieldInfo.DocValuesType normsType = Lucene46FieldInfosReader.getDocValuesType(input, (byte)(val >>> 4 & 0xF));
                        long dvGen = input.readLong();
                        Map<String, String> attributes = input.readStringStringMap();
                        infos[i] = new FieldInfo(name, isIndexed, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, normsType, dvGen, Collections.unmodifiableMap(attributes));
                    }
                    if (codecVersion >= 1) {
                        CodecUtil.checkFooter(input);
                    } else {
                        CodecUtil.checkEOF(input);
                    }
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input.close();
                    } else {
                        IOUtils.closeWhileHandlingException(input);
                    }
                    throw throwable;
                }
                input.close();
                break block9;
            }
            IOUtils.closeWhileHandlingException(input);
        }
        return fieldInfos;
    }

    private static FieldInfo.DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
        if (b == 0) {
            return null;
        }
        if (b == 1) {
            return FieldInfo.DocValuesType.NUMERIC;
        }
        if (b == 2) {
            return FieldInfo.DocValuesType.BINARY;
        }
        if (b == 3) {
            return FieldInfo.DocValuesType.SORTED;
        }
        if (b == 4) {
            return FieldInfo.DocValuesType.SORTED_SET;
        }
        if (b == 5) {
            return FieldInfo.DocValuesType.SORTED_NUMERIC;
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b + " (resource=" + input + ")");
    }
}

