/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.idversion;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;

class SingleDocsEnum
extends DocsEnum {
    private int doc;
    private int singleDocID;
    private Bits liveDocs;

    SingleDocsEnum() {
    }

    public void reset(int singleDocID, Bits liveDocs) {
        this.doc = -1;
        this.liveDocs = liveDocs;
        this.singleDocID = singleDocID;
    }

    @Override
    public int nextDoc() {
        this.doc = this.doc == -1 && (this.liveDocs == null || this.liveDocs.get(this.singleDocID)) ? this.singleDocID : Integer.MAX_VALUE;
        return this.doc;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) {
        this.doc = this.doc == -1 && target <= this.singleDocID && (this.liveDocs == null || this.liveDocs.get(this.singleDocID)) ? this.singleDocID : Integer.MAX_VALUE;
        return this.doc;
    }

    @Override
    public long cost() {
        return 1L;
    }

    @Override
    public int freq() {
        return 1;
    }
}

