/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.idversion;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.codecs.idversion.IDVersionPostingsFormat;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.index.DocsAndPositionsEnum;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Bits;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.BytesRef;

class SingleDocsAndPositionsEnum
extends DocsAndPositionsEnum {
    private int doc;
    private int pos;
    private int singleDocID;
    private Bits liveDocs;
    private long version;
    private final BytesRef payload = new BytesRef(8);

    public SingleDocsAndPositionsEnum() {
        this.payload.length = 8;
    }

    public void reset(int singleDocID, long version, Bits liveDocs) {
        this.doc = -1;
        this.liveDocs = liveDocs;
        this.singleDocID = singleDocID;
        this.version = version;
    }

    @Override
    public int nextDoc() {
        this.doc = this.doc == -1 && (this.liveDocs == null || this.liveDocs.get(this.singleDocID)) ? this.singleDocID : Integer.MAX_VALUE;
        this.pos = -1;
        return this.doc;
    }

    @Override
    public int docID() {
        return this.doc;
    }

    @Override
    public int advance(int target) {
        if (this.doc == -1 && target <= this.singleDocID && (this.liveDocs == null || this.liveDocs.get(this.singleDocID))) {
            this.doc = this.singleDocID;
            this.pos = -1;
        } else {
            this.doc = Integer.MAX_VALUE;
        }
        return this.doc;
    }

    @Override
    public long cost() {
        return 1L;
    }

    @Override
    public int freq() {
        return 1;
    }

    @Override
    public int nextPosition() {
        assert (this.pos == -1);
        this.pos = 0;
        IDVersionPostingsFormat.longToBytes(this.version, this.payload);
        return this.pos;
    }

    @Override
    public BytesRef getPayload() {
        return this.payload;
    }

    @Override
    public int startOffset() {
        return -1;
    }

    @Override
    public int endOffset() {
        return -1;
    }
}

