/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.CharArraySet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;

public final class ClassicAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public ClassicAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    @Deprecated
    public ClassicAnalyzer(Version matchVersion, CharArraySet stopWords) {
        super(matchVersion, stopWords);
    }

    public ClassicAnalyzer() {
        this(STOP_WORDS_SET);
    }

    @Deprecated
    public ClassicAnalyzer(Version matchVersion) {
        this(matchVersion, STOP_WORDS_SET);
    }

    public ClassicAnalyzer(Reader stopwords) throws IOException {
        this(ClassicAnalyzer.loadStopwordSet(stopwords));
    }

    @Deprecated
    public ClassicAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, ClassicAnalyzer.loadStopwordSet(stopwords, matchVersion));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        final ClassicTokenizer src = new ClassicTokenizer(this.getVersion(), reader);
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new ClassicFilter(src);
        tok = new LowerCaseFilter(this.getVersion(), tok);
        tok = new StopFilter(this.getVersion(), tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(src, tok){

            @Override
            protected void setReader(Reader reader) throws IOException {
                src.setMaxTokenLength(ClassicAnalyzer.this.maxTokenLength);
                super.setReader(reader);
            }
        };
    }
}

