/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ngram;

import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;

public class EdgeNGramFilterFactory
extends TokenFilterFactory {
    private final int maxGramSize;
    private final int minGramSize;
    private final String side;

    public EdgeNGramFilterFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 1);
        this.side = this.get(args, "side", EdgeNGramTokenFilter.Side.FRONT.getLabel());
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenFilter create(TokenStream input) {
        return new EdgeNGramTokenFilter(this.luceneMatchVersion, input, this.side, this.minGramSize, this.maxGramSize);
    }
}

