/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;

public class LengthFilterFactory
extends TokenFilterFactory {
    final int min;
    final int max;
    final boolean enablePositionIncrements;
    public static final String MIN_KEY = "min";
    public static final String MAX_KEY = "max";

    public LengthFilterFactory(Map<String, String> args) {
        super(args);
        this.min = this.requireInt(args, MIN_KEY);
        this.max = this.requireInt(args, MAX_KEY);
        this.enablePositionIncrements = this.getBoolean(args, "enablePositionIncrements", true);
        if (!this.enablePositionIncrements && (this.luceneMatchVersion == null || this.luceneMatchVersion.onOrAfter(Version.LUCENE_4_4_0))) {
            throw new IllegalArgumentException("enablePositionIncrements=false is not supported anymore as of Lucene 4.4");
        }
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public LengthFilter create(TokenStream input) {
        if (this.luceneMatchVersion == null) {
            return new LengthFilter(input, this.min, this.max);
        }
        LengthFilter filter = new LengthFilter(this.luceneMatchVersion, this.enablePositionIncrements, input, this.min, this.max);
        return filter;
    }
}

