/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.CharArraySet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.ResourceLoaderAware;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;

public class StopFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String FORMAT_WORDSET = "wordset";
    public static final String FORMAT_SNOWBALL = "snowball";
    private CharArraySet stopWords;
    private final String stopWordFiles;
    private final String format;
    private final boolean ignoreCase;
    private final boolean enablePositionIncrements;

    public StopFilterFactory(Map<String, String> args) {
        super(args);
        this.stopWordFiles = this.get(args, "words");
        this.format = this.get(args, "format", null == this.stopWordFiles ? null : FORMAT_WORDSET);
        this.ignoreCase = this.getBoolean(args, "ignoreCase", false);
        this.enablePositionIncrements = this.getBoolean(args, "enablePositionIncrements", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void inform(ResourceLoader loader) throws IOException {
        if (this.stopWordFiles != null) {
            if (FORMAT_WORDSET.equalsIgnoreCase(this.format)) {
                this.stopWords = this.getWordSet(loader, this.stopWordFiles, this.ignoreCase);
                return;
            } else {
                if (!FORMAT_SNOWBALL.equalsIgnoreCase(this.format)) throw new IllegalArgumentException("Unknown 'format' specified for 'words' file: " + this.format);
                this.stopWords = this.getSnowballWordSet(loader, this.stopWordFiles, this.ignoreCase);
            }
            return;
        } else {
            if (null != this.format) {
                throw new IllegalArgumentException("'format' can not be specified w/o an explicit 'words' file: " + this.format);
            }
            this.stopWords = this.luceneMatchVersion == null ? new CharArraySet(StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase) : new CharArraySet(this.luceneMatchVersion, StopAnalyzer.ENGLISH_STOP_WORDS_SET, this.ignoreCase);
        }
    }

    public boolean isEnablePositionIncrements() {
        return this.enablePositionIncrements;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getStopWords() {
        return this.stopWords;
    }

    @Override
    public TokenStream create(TokenStream input) {
        StopFilter stopFilter = this.luceneMatchVersion == null ? new StopFilter(input, this.stopWords) : new StopFilter(this.luceneMatchVersion, input, this.stopWords);
        stopFilter.setEnablePositionIncrements(this.enablePositionIncrements);
        return stopFilter;
    }
}

