/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.core.StopFilter;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.CharArraySet;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.util.StopwordAnalyzerBase;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.util.Version;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public static final CharArraySet ENGLISH_STOP_WORDS_SET;

    public StopAnalyzer() {
        this(ENGLISH_STOP_WORDS_SET);
    }

    @Deprecated
    public StopAnalyzer(Version matchVersion) {
        this(matchVersion, ENGLISH_STOP_WORDS_SET);
    }

    public StopAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    @Deprecated
    public StopAnalyzer(Version matchVersion, CharArraySet stopWords) {
        super(matchVersion, stopWords);
    }

    public StopAnalyzer(File stopwordsFile) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwordsFile));
    }

    @Deprecated
    public StopAnalyzer(Version matchVersion, File stopwordsFile) throws IOException {
        this(matchVersion, StopAnalyzer.loadStopwordSet(stopwordsFile, matchVersion));
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwords));
    }

    @Deprecated
    public StopAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, StopAnalyzer.loadStopwordSet(stopwords, matchVersion));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        LowerCaseTokenizer source = new LowerCaseTokenizer(this.getVersion(), reader);
        return new Analyzer.TokenStreamComponents(source, new StopFilter(this.getVersion(), source, this.stopwords));
    }

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet stopSet = new CharArraySet(stopWords, false);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(stopSet);
    }
}

