/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis;

import java.io.Reader;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.org.apache.lucene.analysis.AnalyzerWrapper;

public abstract class DelegatingAnalyzerWrapper
extends AnalyzerWrapper {
    protected DelegatingAnalyzerWrapper(Analyzer.ReuseStrategy fallbackStrategy) {
        super(new DelegatingReuseStrategy(fallbackStrategy));
        ((DelegatingReuseStrategy)this.getReuseStrategy()).wrapper = this;
    }

    @Override
    protected final Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        return super.wrapComponents(fieldName, components);
    }

    @Override
    protected final Reader wrapReader(String fieldName, Reader reader) {
        return super.wrapReader(fieldName, reader);
    }

    private static final class DelegatingReuseStrategy
    extends Analyzer.ReuseStrategy {
        DelegatingAnalyzerWrapper wrapper;
        private final Analyzer.ReuseStrategy fallbackStrategy;

        DelegatingReuseStrategy(Analyzer.ReuseStrategy fallbackStrategy) {
            this.fallbackStrategy = fallbackStrategy;
        }

        @Override
        public Analyzer.TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            if (analyzer == this.wrapper) {
                Analyzer wrappedAnalyzer = this.wrapper.getWrappedAnalyzer(fieldName);
                return wrappedAnalyzer.getReuseStrategy().getReusableComponents(wrappedAnalyzer, fieldName);
            }
            return this.fallbackStrategy.getReusableComponents(analyzer, fieldName);
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, Analyzer.TokenStreamComponents components) {
            if (analyzer == this.wrapper) {
                Analyzer wrappedAnalyzer = this.wrapper.getWrappedAnalyzer(fieldName);
                wrappedAnalyzer.getReuseStrategy().setReusableComponents(wrappedAnalyzer, fieldName, components);
            } else {
                this.fallbackStrategy.setReusableComponents(analyzer, fieldName, components);
            }
        }
    }
}

