/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Circle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Point;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.SpatialRelation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.impl.PointImpl;

public class JtsPoint
implements Point {
    private final SpatialContext ctx;
    private com.vividsolutions.jts.geom.Point pointGeom;
    private final boolean empty;

    public JtsPoint(com.vividsolutions.jts.geom.Point pointGeom, SpatialContext ctx) {
        this.ctx = ctx;
        this.pointGeom = pointGeom;
        this.empty = pointGeom.isEmpty();
    }

    public com.vividsolutions.jts.geom.Point getGeom() {
        return this.pointGeom;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public Point getCenter() {
        return this;
    }

    @Override
    public boolean hasArea() {
        return false;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        return 0.0;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.ctx.makeRectangle(this, this);
    }

    @Override
    public Circle getBuffered(double distance, SpatialContext ctx) {
        return ctx.makeCircle(this, distance);
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (this.isEmpty() || other.isEmpty()) {
            return SpatialRelation.DISJOINT;
        }
        if (other instanceof Point) {
            return this.equals(other) ? SpatialRelation.INTERSECTS : SpatialRelation.DISJOINT;
        }
        return other.relate(this).transpose();
    }

    @Override
    public double getX() {
        return this.isEmpty() ? Double.NaN : this.pointGeom.getX();
    }

    @Override
    public double getY() {
        return this.isEmpty() ? Double.NaN : this.pointGeom.getY();
    }

    @Override
    public void reset(double x, double y) {
        assert (!this.isEmpty());
        CoordinateSequence cSeq = this.pointGeom.getCoordinateSequence();
        cSeq.setOrdinate(0, 0, x);
        cSeq.setOrdinate(0, 1, y);
    }

    public String toString() {
        return "Pt(x=" + this.getX() + ",y=" + this.getY() + ")";
    }

    @Override
    public boolean equals(Object o) {
        return PointImpl.equals(this, o);
    }

    public int hashCode() {
        return PointImpl.hashCode(this);
    }
}

