/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Puntal;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.operation.union.UnaryUnionOp;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import java.util.ArrayList;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.jts.JtsSpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.exception.InvalidShapeException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Circle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Point;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.SpatialRelation;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.impl.BufferedLineString;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.impl.PointImpl;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.impl.Range;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.impl.RectangleImpl;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.jts.JtsPoint;

public class JtsGeometry
implements Shape {
    public static final String SYSPROP_ASSERT_VALIDATE = "spatial4j.JtsGeometry.assertValidate";
    private final Geometry geom;
    private final boolean hasArea;
    private final Rectangle bbox;
    protected final JtsSpatialContext ctx;
    protected PreparedGeometry preparedGeometry;
    protected boolean validated = false;

    public JtsGeometry(Geometry geom, JtsSpatialContext ctx, boolean dateline180Check, boolean allowMultiOverlap) {
        this.ctx = ctx;
        if (geom.getClass().equals(GeometryCollection.class)) {
            throw new IllegalArgumentException("JtsGeometry does not support GeometryCollection but does support its subclasses.");
        }
        if (ctx.isGeo()) {
            if (dateline180Check) {
                JtsGeometry.unwrapDateline(geom);
            }
            if (allowMultiOverlap) {
                geom = JtsGeometry.unionGeometryCollection(geom);
            }
            geom = JtsGeometry.cutUnwrappedGeomInto360(geom);
            assert (geom.getEnvelopeInternal().getWidth() <= 360.0);
            assert (!geom.getClass().equals(GeometryCollection.class)) : "GeometryCollection unsupported";
            this.bbox = this.computeGeoBBox(geom);
        } else {
            if (allowMultiOverlap) {
                geom = JtsGeometry.unionGeometryCollection(geom);
            }
            Envelope env = geom.getEnvelopeInternal();
            this.bbox = new RectangleImpl(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), ctx);
        }
        geom.getEnvelopeInternal();
        this.geom = geom;
        assert (this.assertValidate());
        this.hasArea = !(geom instanceof Lineal) && !(geom instanceof Puntal);
    }

    private boolean assertValidate() {
        String assertValidate = System.getProperty(SYSPROP_ASSERT_VALIDATE);
        if (assertValidate == null || Boolean.parseBoolean(assertValidate)) {
            this.validate();
        }
        return true;
    }

    public void validate() throws InvalidShapeException {
        if (!this.validated) {
            IsValidOp isValidOp = new IsValidOp(this.geom);
            if (!isValidOp.isValid()) {
                throw new InvalidShapeException(isValidOp.getValidationError().toString());
            }
            this.validated = true;
        }
    }

    public void index() {
        if (this.preparedGeometry == null) {
            this.preparedGeometry = PreparedGeometryFactory.prepare((Geometry)this.geom);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.geom.isEmpty();
    }

    protected Rectangle computeGeoBBox(Geometry geoms) {
        if (geoms.isEmpty()) {
            return new RectangleImpl(Double.NaN, Double.NaN, Double.NaN, Double.NaN, this.ctx);
        }
        Envelope env = geoms.getEnvelopeInternal();
        if (env.getWidth() > 180.0 && geoms.getNumGeometries() > 1) {
            Range xRange = null;
            for (int i = 0; i < geoms.getNumGeometries(); ++i) {
                Envelope envI = geoms.getGeometryN(i).getEnvelopeInternal();
                Range.LongitudeRange xRange2 = new Range.LongitudeRange(envI.getMinX(), envI.getMaxX());
                if ((xRange = xRange == null ? xRange2 : xRange.expandTo(xRange2)) == Range.LongitudeRange.WORLD_180E180W) break;
            }
            return new RectangleImpl(xRange.getMin(), xRange.getMax(), env.getMinY(), env.getMaxY(), this.ctx);
        }
        return new RectangleImpl(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), this.ctx);
    }

    @Override
    public JtsGeometry getBuffered(double distance, SpatialContext ctx) {
        return this.ctx.makeShape(this.geom.buffer(distance), true, true);
    }

    @Override
    public boolean hasArea() {
        return this.hasArea;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        double geomArea = this.geom.getArea();
        if (ctx == null || geomArea == 0.0) {
            return geomArea;
        }
        double bboxArea = this.getBoundingBox().getArea(null);
        assert (bboxArea >= geomArea);
        double filledRatio = geomArea / bboxArea;
        return this.getBoundingBox().getArea(ctx) * filledRatio;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    @Override
    public JtsPoint getCenter() {
        if (this.isEmpty()) {
            return new JtsPoint(this.ctx.getGeometryFactory().createPoint((Coordinate)null), this.ctx);
        }
        return new JtsPoint(this.geom.getCentroid(), this.ctx);
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (other instanceof Point) {
            return this.relate((Point)other);
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        if (other instanceof Circle) {
            return this.relate((Circle)other);
        }
        if (other instanceof JtsGeometry) {
            return this.relate((JtsGeometry)other);
        }
        if (other instanceof BufferedLineString) {
            throw new UnsupportedOperationException("Can't use BufferedLineString with JtsGeometry");
        }
        return other.relate(this).transpose();
    }

    public SpatialRelation relate(Point pt) {
        if (!this.getBoundingBox().relate(pt).intersects()) {
            return SpatialRelation.DISJOINT;
        }
        com.vividsolutions.jts.geom.Point ptGeom = pt instanceof JtsPoint ? ((JtsPoint)pt).getGeom() : this.ctx.getGeometryFactory().createPoint(new Coordinate(pt.getX(), pt.getY()));
        return this.relate((Geometry)ptGeom);
    }

    public SpatialRelation relate(Rectangle rectangle) {
        SpatialRelation bboxR = this.bbox.relate(rectangle);
        if (bboxR == SpatialRelation.WITHIN || bboxR == SpatialRelation.DISJOINT) {
            return bboxR;
        }
        return this.relate(this.ctx.getGeometryFrom(rectangle));
    }

    public SpatialRelation relate(Circle circle) {
        SpatialRelation bboxR = this.bbox.relate(circle);
        if (bboxR == SpatialRelation.WITHIN || bboxR == SpatialRelation.DISJOINT) {
            return bboxR;
        }
        Coordinate[] coords = this.geom.getCoordinates();
        int outside = 0;
        int i = 0;
        for (Coordinate coord : coords) {
            ++i;
            SpatialRelation sect = circle.relate(new PointImpl(coord.x, coord.y, this.ctx));
            if (sect == SpatialRelation.DISJOINT) {
                ++outside;
            }
            if (i == outside || outside == 0) continue;
            return SpatialRelation.INTERSECTS;
        }
        if (i == outside) {
            return this.relate(circle.getCenter()) == SpatialRelation.DISJOINT ? SpatialRelation.DISJOINT : SpatialRelation.CONTAINS;
        }
        assert (outside == 0);
        return SpatialRelation.WITHIN;
    }

    public SpatialRelation relate(JtsGeometry jtsGeometry) {
        return this.relate(jtsGeometry.geom);
    }

    protected SpatialRelation relate(Geometry oGeom) {
        if (oGeom instanceof com.vividsolutions.jts.geom.Point) {
            if (this.preparedGeometry != null) {
                return this.preparedGeometry.disjoint(oGeom) ? SpatialRelation.DISJOINT : SpatialRelation.CONTAINS;
            }
            return this.geom.disjoint(oGeom) ? SpatialRelation.DISJOINT : SpatialRelation.CONTAINS;
        }
        if (this.preparedGeometry == null) {
            return JtsGeometry.intersectionMatrixToSpatialRelation(this.geom.relate(oGeom));
        }
        if (this.preparedGeometry.covers(oGeom)) {
            return SpatialRelation.CONTAINS;
        }
        if (this.preparedGeometry.coveredBy(oGeom)) {
            return SpatialRelation.WITHIN;
        }
        if (this.preparedGeometry.intersects(oGeom)) {
            return SpatialRelation.INTERSECTS;
        }
        return SpatialRelation.DISJOINT;
    }

    public static SpatialRelation intersectionMatrixToSpatialRelation(IntersectionMatrix matrix) {
        if (matrix.isCovers()) {
            return SpatialRelation.CONTAINS;
        }
        if (matrix.isCoveredBy()) {
            return SpatialRelation.WITHIN;
        }
        if (matrix.isDisjoint()) {
            return SpatialRelation.DISJOINT;
        }
        return SpatialRelation.INTERSECTS;
    }

    public String toString() {
        return this.geom.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JtsGeometry that = (JtsGeometry)o;
        return this.geom.equalsExact(that.geom);
    }

    public int hashCode() {
        return this.geom.getEnvelopeInternal().hashCode();
    }

    public Geometry getGeom() {
        return this.geom;
    }

    private static int unwrapDateline(Geometry geom) {
        if (geom.getEnvelopeInternal().getWidth() < 180.0) {
            return 0;
        }
        final int[] crossings = new int[]{0};
        geom.apply(new GeometryFilter(){

            public void filter(Geometry geom) {
                int cross = 0;
                if (geom instanceof LineString) {
                    if (geom.getEnvelopeInternal().getWidth() < 180.0) {
                        return;
                    }
                    cross = JtsGeometry.unwrapDateline((LineString)geom);
                } else if (geom instanceof Polygon) {
                    if (geom.getEnvelopeInternal().getWidth() < 180.0) {
                        return;
                    }
                    cross = JtsGeometry.unwrapDateline((Polygon)geom);
                } else {
                    return;
                }
                crossings[0] = Math.max(crossings[0], cross);
            }
        });
        return crossings[0];
    }

    private static int unwrapDateline(Polygon poly) {
        LineString exteriorRing = poly.getExteriorRing();
        int cross = JtsGeometry.unwrapDateline(exteriorRing);
        if (cross > 0) {
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                LineString innerLineString = poly.getInteriorRingN(i);
                JtsGeometry.unwrapDateline(innerLineString);
                int shiftCount = 0;
                while (!exteriorRing.contains((Geometry)innerLineString)) {
                    if (shiftCount > cross) {
                        throw new IllegalArgumentException("The inner ring doesn't appear to be within the exterior: " + exteriorRing + " inner: " + innerLineString);
                    }
                    JtsGeometry.shiftGeomByX((Geometry)innerLineString, 360);
                    ++shiftCount;
                }
            }
            poly.geometryChanged();
        }
        return cross;
    }

    private static int unwrapDateline(LineString lineString) {
        CoordinateSequence cseq = lineString.getCoordinateSequence();
        int size = cseq.size();
        if (size <= 1) {
            return 0;
        }
        int shiftX = 0;
        int shiftXPage = 0;
        int shiftXPageMin = 0;
        int shiftXPageMax = 0;
        double prevX = cseq.getX(0);
        for (int i = 1; i < size; ++i) {
            double thisX_orig = cseq.getX(i);
            assert (thisX_orig >= -180.0 && thisX_orig <= 180.0) : "X not in geo bounds";
            double thisX = thisX_orig + (double)shiftX;
            if (prevX - thisX > 180.0) {
                thisX += 360.0;
                shiftX += 360;
                shiftXPageMax = Math.max(shiftXPageMax, ++shiftXPage);
            } else if (thisX - prevX > 180.0) {
                thisX -= 360.0;
                shiftX -= 360;
                shiftXPageMin = Math.min(shiftXPageMin, --shiftXPage);
            }
            if (shiftXPage != 0) {
                cseq.setOrdinate(i, 0, thisX);
            }
            prevX = thisX;
        }
        if (lineString instanceof LinearRing) {
            assert (cseq.getCoordinate(0).equals((Object)cseq.getCoordinate(size - 1)));
            assert (shiftXPage == 0);
        }
        assert (shiftXPageMax >= 0 && shiftXPageMin <= 0);
        JtsGeometry.shiftGeomByX((Geometry)lineString, shiftXPageMin * -360);
        int crossings = shiftXPageMax - shiftXPageMin;
        if (crossings > 0) {
            lineString.geometryChanged();
        }
        return crossings;
    }

    private static void shiftGeomByX(Geometry geom, final int xShift) {
        if (xShift == 0) {
            return;
        }
        geom.apply(new CoordinateSequenceFilter(){

            public void filter(CoordinateSequence seq, int i) {
                seq.setOrdinate(i, 0, seq.getX(i) + (double)xShift);
            }

            public boolean isDone() {
                return false;
            }

            public boolean isGeometryChanged() {
                return true;
            }
        });
    }

    private static Geometry unionGeometryCollection(Geometry geom) {
        if (geom instanceof GeometryCollection) {
            return geom.union();
        }
        return geom;
    }

    private static Geometry cutUnwrappedGeomInto360(Geometry geom) {
        Envelope geomEnv = geom.getEnvelopeInternal();
        if (geomEnv.getMinX() >= -180.0 && geomEnv.getMaxX() <= 180.0) {
            return geom;
        }
        assert (geom.isValid()) : "geom";
        ArrayList<Geometry> geomList = new ArrayList<Geometry>();
        int page = 0;
        while (true) {
            double minX = -180 + page * 360;
            if (geomEnv.getMaxX() <= minX) break;
            Geometry rect = geom.getFactory().toGeometry(new Envelope(minX, minX + 360.0, -90.0, 90.0));
            assert (rect.isValid()) : "rect";
            Geometry pageGeom = rect.intersection(geom);
            assert (pageGeom.isValid()) : "pageGeom";
            JtsGeometry.shiftGeomByX(pageGeom, page * -360);
            geomList.add(pageGeom);
            ++page;
        }
        return UnaryUnionOp.union(geomList);
    }
}

