/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.impl;

import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Circle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Point;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.SpatialRelation;

public class PointImpl
implements Point {
    private final SpatialContext ctx;
    private double x;
    private double y;

    public PointImpl(double x, double y, SpatialContext ctx) {
        this.ctx = ctx;
        this.reset(x, y);
    }

    @Override
    public boolean isEmpty() {
        return Double.isNaN(this.x);
    }

    @Override
    public void reset(double x, double y) {
        assert (!this.isEmpty());
        this.x = x;
        this.y = y;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.ctx.makeRectangle(this, this);
    }

    @Override
    public PointImpl getCenter() {
        return this;
    }

    @Override
    public Circle getBuffered(double distance, SpatialContext ctx) {
        return ctx.makeCircle(this, distance);
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (this.isEmpty() || other.isEmpty()) {
            return SpatialRelation.DISJOINT;
        }
        if (other instanceof Point) {
            return this.equals(other) ? SpatialRelation.INTERSECTS : SpatialRelation.DISJOINT;
        }
        return other.relate(this).transpose();
    }

    @Override
    public boolean hasArea() {
        return false;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        return 0.0;
    }

    public String toString() {
        return "Pt(x=" + this.x + ",y=" + this.y + ")";
    }

    @Override
    public boolean equals(Object o) {
        return PointImpl.equals(this, o);
    }

    public static boolean equals(Point thiz, Object o) {
        assert (thiz != null);
        if (thiz == o) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point point = (Point)o;
        if (Double.compare(point.getX(), thiz.getX()) != 0) {
            return false;
        }
        return Double.compare(point.getY(), thiz.getY()) == 0;
    }

    public int hashCode() {
        return PointImpl.hashCode(this);
    }

    public static int hashCode(Point thiz) {
        long temp = thiz.getX() != 0.0 ? Double.doubleToLongBits(thiz.getX()) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = thiz.getY() != 0.0 ? Double.doubleToLongBits(thiz.getY()) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

