/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.io;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.exception.InvalidShapeException;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.io.ParseUtils;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Circle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Point;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Shape;

@Deprecated
public class LegacyShapeReadWriterFormat {
    private LegacyShapeReadWriterFormat() {
    }

    public static String writeShape(Shape shape) {
        return LegacyShapeReadWriterFormat.writeShape(shape, LegacyShapeReadWriterFormat.makeNumberFormat(6));
    }

    public static String writeShape(Shape shape, NumberFormat nf) {
        if (shape instanceof Point) {
            Point point = (Point)shape;
            return nf.format(point.getX()) + " " + nf.format(point.getY());
        }
        if (shape instanceof Rectangle) {
            Rectangle rect = (Rectangle)shape;
            return nf.format(rect.getMinX()) + " " + nf.format(rect.getMinY()) + " " + nf.format(rect.getMaxX()) + " " + nf.format(rect.getMaxY());
        }
        if (shape instanceof Circle) {
            Circle c = (Circle)shape;
            return "Circle(" + nf.format(c.getCenter().getX()) + " " + nf.format(c.getCenter().getY()) + " " + "d=" + nf.format(c.getRadius()) + ")";
        }
        return shape.toString();
    }

    public static NumberFormat makeNumberFormat(int fractionDigits) {
        NumberFormat nf = NumberFormat.getInstance(Locale.ROOT);
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(fractionDigits);
        nf.setMinimumFractionDigits(fractionDigits);
        return nf;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Shape readShapeOrNull(String str, SpatialContext ctx) throws InvalidShapeException {
        if (str == null || str.length() == 0) {
            throw new InvalidShapeException(str);
        }
        if (Character.isLetter(str.charAt(0))) {
            Point pt;
            int idx;
            if (!str.startsWith("Circle(") && !str.startsWith("CIRCLE(") || (idx = str.lastIndexOf(41)) <= 0) return null;
            String body = str.substring("Circle(".length(), idx);
            StringTokenizer st = new StringTokenizer(body, " ");
            String token = st.nextToken();
            if (token.indexOf(44) != -1) {
                pt = LegacyShapeReadWriterFormat.readLatCommaLonPoint(token, ctx);
            } else {
                double x = Double.parseDouble(token);
                double y = Double.parseDouble(st.nextToken());
                pt = ctx.makePoint(x, y);
            }
            Double d = null;
            String arg = st.nextToken();
            idx = arg.indexOf(61);
            if (idx > 0) {
                String k = arg.substring(0, idx);
                if (!k.equals("d") && !k.equals("distance")) throw new InvalidShapeException("unknown arg: " + k + " :: " + str);
                d = Double.parseDouble(arg.substring(idx + 1));
            } else {
                d = Double.parseDouble(arg);
            }
            if (st.hasMoreTokens()) {
                throw new InvalidShapeException("Extra arguments: " + st.nextToken() + " :: " + str);
            }
            if (d != null) return ctx.makeCircle(pt, d);
            throw new InvalidShapeException("Missing Distance: " + str);
        }
        if (str.indexOf(44) != -1) {
            return LegacyShapeReadWriterFormat.readLatCommaLonPoint(str, ctx);
        }
        StringTokenizer st = new StringTokenizer(str, " ");
        double p0 = Double.parseDouble(st.nextToken());
        double p1 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return ctx.makePoint(p0, p1);
        double p2 = Double.parseDouble(st.nextToken());
        double p3 = Double.parseDouble(st.nextToken());
        if (!st.hasMoreTokens()) return ctx.makeRectangle(p0, p2, p1, p3);
        throw new InvalidShapeException("Only 4 numbers supported (rect) but found more: " + str);
    }

    private static Point readLatCommaLonPoint(String value, SpatialContext ctx) throws InvalidShapeException {
        double[] latLon = ParseUtils.parseLatitudeLongitude(value);
        return ctx.makePoint(latLon[1], latLon[0]);
    }
}

