/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.jts;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContextFactory;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.jts.JtsSpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.io.jts.JtsBinaryCodec;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.io.jts.JtsWktShapeParser;

public class JtsSpatialContextFactory
extends SpatialContextFactory {
    protected static final PrecisionModel defaultPrecisionModel = new PrecisionModel();
    public PrecisionModel precisionModel = defaultPrecisionModel;
    public int srid = 0;
    public CoordinateSequenceFactory coordinateSequenceFactory = CoordinateArraySequenceFactory.instance();
    public JtsWktShapeParser.DatelineRule datelineRule = JtsWktShapeParser.DatelineRule.width180;
    public JtsWktShapeParser.ValidationRule validationRule = JtsWktShapeParser.ValidationRule.error;
    public boolean autoIndex = false;
    public boolean allowMultiOverlap = false;
    public boolean useJtsPoint = true;
    public boolean useJtsLineString = true;

    public JtsSpatialContextFactory() {
        this.wktShapeParserClass = JtsWktShapeParser.class;
        this.binaryCodecClass = JtsBinaryCodec.class;
    }

    @Override
    protected void init(Map<String, String> args, ClassLoader classLoader) {
        super.init(args, classLoader);
        this.initField("datelineRule");
        this.initField("validationRule");
        this.initField("autoIndex");
        this.initField("allowMultiOverlap");
        this.initField("useJtsPoint");
        this.initField("useJtsLineString");
        String scaleStr = args.get("precisionScale");
        String modelStr = args.get("precisionModel");
        if (scaleStr != null) {
            if (modelStr != null && !modelStr.equals("fixed")) {
                throw new RuntimeException("Since precisionScale was specified; precisionModel must be 'fixed' but got: " + modelStr);
            }
            this.precisionModel = new PrecisionModel(Double.parseDouble(scaleStr));
        } else if (modelStr != null) {
            if (modelStr.equals("floating")) {
                this.precisionModel = new PrecisionModel(PrecisionModel.FLOATING);
            } else if (modelStr.equals("floating_single")) {
                this.precisionModel = new PrecisionModel(PrecisionModel.FLOATING_SINGLE);
            } else {
                if (modelStr.equals("fixed")) {
                    throw new RuntimeException("For fixed model, must specifiy 'precisionScale'");
                }
                throw new RuntimeException("Unknown precisionModel: " + modelStr);
            }
        }
    }

    public GeometryFactory getGeometryFactory() {
        if (this.precisionModel == null || this.coordinateSequenceFactory == null) {
            throw new IllegalStateException("precision model or coord seq factory can't be null");
        }
        return new GeometryFactory(this.precisionModel, this.srid, this.coordinateSequenceFactory);
    }

    @Override
    public JtsSpatialContext newSpatialContext() {
        return new JtsSpatialContext(this);
    }
}

