/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.context.SpatialContext;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.distance.CartesianDistCalc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.distance.DistanceCalculator;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.distance.GeodesicSphereDistCalc;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.io.BinaryCodec;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.io.WktShapeParser;
import org.apache.flink.streaming.connectors.elasticsearch.shaded.com.spatial4j.core.shape.Rectangle;

public class SpatialContextFactory {
    protected Map<String, String> args;
    protected ClassLoader classLoader;
    public boolean geo = true;
    public DistanceCalculator distCalc;
    public Rectangle worldBounds;
    public boolean normWrapLongitude = false;
    public Class<? extends WktShapeParser> wktShapeParserClass = WktShapeParser.class;
    public Class<? extends BinaryCodec> binaryCodecClass = BinaryCodec.class;

    public static SpatialContext makeSpatialContext(Map<String, String> args, ClassLoader classLoader) {
        SpatialContextFactory instance;
        String cname;
        if (classLoader == null) {
            classLoader = SpatialContextFactory.class.getClassLoader();
        }
        if ((cname = args.get("spatialContextFactory")) == null) {
            cname = System.getProperty("SpatialContextFactory");
        }
        if (cname == null) {
            instance = new SpatialContextFactory();
        } else {
            try {
                Class<?> c = classLoader.loadClass(cname);
                instance = (SpatialContextFactory)c.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        instance.init(args, classLoader);
        return instance.newSpatialContext();
    }

    protected void init(Map<String, String> args, ClassLoader classLoader) {
        this.args = args;
        this.classLoader = classLoader;
        this.initField("geo");
        this.initCalculator();
        this.initField("wktShapeParserClass");
        this.initWorldBounds();
        this.initField("normWrapLongitude");
        this.initField("binaryCodecClass");
    }

    protected void initField(String name) {
        Field field;
        try {
            field = this.getClass().getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
        String str = this.args.get(name);
        if (str != null) {
            try {
                Object o;
                if (field.getType() == Boolean.TYPE) {
                    o = Boolean.valueOf(str);
                } else if (field.getType() == Class.class) {
                    try {
                        o = this.classLoader.loadClass(str);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                } else if (field.getType().isEnum()) {
                    o = Enum.valueOf(field.getType().asSubclass(Enum.class), str);
                } else {
                    throw new Error("unsupported field type: " + field.getType());
                }
                field.set(this, o);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid value '" + str + "' on field " + name + " of type " + field.getType(), e);
            }
        }
    }

    protected void initCalculator() {
        String calcStr = this.args.get("distCalculator");
        if (calcStr == null) {
            return;
        }
        if (calcStr.equalsIgnoreCase("haversine")) {
            this.distCalc = new GeodesicSphereDistCalc.Haversine();
        } else if (calcStr.equalsIgnoreCase("lawOfCosines")) {
            this.distCalc = new GeodesicSphereDistCalc.LawOfCosines();
        } else if (calcStr.equalsIgnoreCase("vincentySphere")) {
            this.distCalc = new GeodesicSphereDistCalc.Vincenty();
        } else if (calcStr.equalsIgnoreCase("cartesian")) {
            this.distCalc = new CartesianDistCalc();
        } else if (calcStr.equalsIgnoreCase("cartesian^2")) {
            this.distCalc = new CartesianDistCalc(true);
        } else {
            throw new RuntimeException("Unknown calculator: " + calcStr);
        }
    }

    protected void initWorldBounds() {
        String worldBoundsStr = this.args.get("worldBounds");
        if (worldBoundsStr == null) {
            return;
        }
        SpatialContext ctx = this.newSpatialContext();
        this.worldBounds = (Rectangle)ctx.readShape(worldBoundsStr);
    }

    public SpatialContext newSpatialContext() {
        return new SpatialContext(this);
    }

    public WktShapeParser makeWktShapeParser(SpatialContext ctx) {
        return this.makeClassInstance(this.wktShapeParserClass, ctx, this);
    }

    public BinaryCodec makeBinaryCodec(SpatialContext ctx) {
        return this.makeClassInstance(this.binaryCodecClass, ctx, this);
    }

    private <T> T makeClassInstance(Class<? extends T> clazz, Object ... ctorArgs) {
        try {
            block2: for (Constructor<?> ctor : clazz.getConstructors()) {
                Class<?>[] parameterTypes = ctor.getParameterTypes();
                if (parameterTypes.length != ctorArgs.length) continue;
                for (int i = 0; i < ctorArgs.length; ++i) {
                    Object ctorArg = ctorArgs[i];
                    if (!parameterTypes[i].isAssignableFrom(ctorArg.getClass())) continue block2;
                }
                return clazz.cast(ctor.newInstance(ctorArgs));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException(clazz + " needs a constructor that takes: " + Arrays.toString(ctorArgs));
    }
}

