/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.api.java.utils.ParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.sink.RichSinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch.IndexRequestBuilder;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticsearchSink<T>
extends RichSinkFunction<T> {
    public static final String CONFIG_KEY_BULK_FLUSH_MAX_ACTIONS = "bulk.flush.max.actions";
    public static final String CONFIG_KEY_BULK_FLUSH_MAX_SIZE_MB = "bulk.flush.max.size.mb";
    public static final String CONFIG_KEY_BULK_FLUSH_INTERVAL_MS = "bulk.flush.interval.ms";
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchSink.class);
    private final Map<String, String> userConfig;
    private final List<TransportAddress> transportNodes;
    private final IndexRequestBuilder<T> indexRequestBuilder;
    private transient Node node;
    private transient Client client;
    private transient BulkProcessor bulkProcessor;
    private final AtomicBoolean hasFailure = new AtomicBoolean(false);
    private final AtomicReference<Throwable> failureThrowable = new AtomicReference();

    public ElasticsearchSink(Map<String, String> userConfig, IndexRequestBuilder<T> indexRequestBuilder) {
        this.userConfig = userConfig;
        this.indexRequestBuilder = indexRequestBuilder;
        this.transportNodes = null;
    }

    public ElasticsearchSink(Map<String, String> userConfig, List<TransportAddress> transportNodes, IndexRequestBuilder<T> indexRequestBuilder) {
        this.userConfig = userConfig;
        this.indexRequestBuilder = indexRequestBuilder;
        this.transportNodes = transportNodes;
    }

    public void open(Configuration configuration) {
        Settings settings;
        if (this.transportNodes == null) {
            settings = ImmutableSettings.settingsBuilder().put(this.userConfig).put("http.enabled", false).build();
            this.node = NodeBuilder.nodeBuilder().settings(settings).client(true).data(false).node();
            this.client = this.node.client();
            if (LOG.isInfoEnabled()) {
                LOG.info("Created Elasticsearch Client {} from embedded Node", (Object)this.client);
            }
        } else {
            settings = ImmutableSettings.settingsBuilder().put(this.userConfig).build();
            TransportClient transportClient = new TransportClient(settings);
            for (TransportAddress transport : this.transportNodes) {
                transportClient.addTransportAddress(transport);
            }
            ImmutableList nodes = transportClient.connectedNodes();
            if (nodes.isEmpty()) {
                throw new RuntimeException("Client is not connected to any Elasticsearch nodes!");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected to nodes: " + nodes.toString());
            }
            this.client = transportClient;
            if (LOG.isInfoEnabled()) {
                LOG.info("Created Elasticsearch TransportClient {}", (Object)this.client);
            }
        }
        BulkProcessor.Builder bulkProcessorBuilder = BulkProcessor.builder((Client)this.client, (BulkProcessor.Listener)new BulkProcessor.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                if (response.hasFailures()) {
                    for (BulkItemResponse itemResp : response.getItems()) {
                        if (!itemResp.isFailed()) continue;
                        LOG.error("Failed to index document in Elasticsearch: " + itemResp.getFailureMessage());
                        ElasticsearchSink.this.failureThrowable.compareAndSet(null, new RuntimeException(itemResp.getFailureMessage()));
                    }
                    ElasticsearchSink.this.hasFailure.set(true);
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Throwable failure) {
                LOG.error(failure.getMessage());
                ElasticsearchSink.this.failureThrowable.compareAndSet(null, failure);
                ElasticsearchSink.this.hasFailure.set(true);
            }
        });
        bulkProcessorBuilder.setConcurrentRequests(0);
        ParameterTool params = ParameterTool.fromMap(this.userConfig);
        if (params.has(CONFIG_KEY_BULK_FLUSH_MAX_ACTIONS)) {
            bulkProcessorBuilder.setBulkActions(params.getInt(CONFIG_KEY_BULK_FLUSH_MAX_ACTIONS));
        }
        if (params.has(CONFIG_KEY_BULK_FLUSH_MAX_SIZE_MB)) {
            bulkProcessorBuilder.setBulkSize(new ByteSizeValue((long)params.getInt(CONFIG_KEY_BULK_FLUSH_MAX_SIZE_MB), ByteSizeUnit.MB));
        }
        if (params.has(CONFIG_KEY_BULK_FLUSH_INTERVAL_MS)) {
            bulkProcessorBuilder.setFlushInterval(TimeValue.timeValueMillis((long)params.getInt(CONFIG_KEY_BULK_FLUSH_INTERVAL_MS)));
        }
        this.bulkProcessor = bulkProcessorBuilder.build();
    }

    public void invoke(T element) {
        IndexRequest indexRequest = this.indexRequestBuilder.createIndexRequest(element, this.getRuntimeContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Emitting IndexRequest: {}", (Object)indexRequest);
        }
        this.bulkProcessor.add(indexRequest);
    }

    public void close() {
        if (this.bulkProcessor != null) {
            this.bulkProcessor.close();
            this.bulkProcessor = null;
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.node != null) {
            this.node.close();
        }
        if (this.hasFailure.get()) {
            Throwable cause = this.failureThrowable.get();
            if (cause != null) {
                throw new RuntimeException("An error occured in ElasticsearchSink.", cause);
            }
            throw new RuntimeException("An error occured in ElasticsearchSink.");
        }
    }
}

