/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch6Configuration;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch6DynamicSink;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchOptions;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchValidationUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.factories.SerializationFormatFactory;
import org.apache.flink.table.utils.TableSchemaUtils;

@Internal
public class Elasticsearch6DynamicSinkFactory
implements DynamicTableSinkFactory {
    private static final Set<ConfigOption<?>> requiredOptions = Stream.of(ElasticsearchOptions.HOSTS_OPTION, ElasticsearchOptions.INDEX_OPTION, ElasticsearchOptions.DOCUMENT_TYPE_OPTION).collect(Collectors.toSet());
    private static final Set<ConfigOption<?>> optionalOptions = Stream.of(ElasticsearchOptions.KEY_DELIMITER_OPTION, ElasticsearchOptions.FAILURE_HANDLER_OPTION, ElasticsearchOptions.FLUSH_ON_CHECKPOINT_OPTION, ElasticsearchOptions.BULK_FLASH_MAX_SIZE_OPTION, ElasticsearchOptions.BULK_FLUSH_MAX_ACTIONS_OPTION, ElasticsearchOptions.BULK_FLUSH_INTERVAL_OPTION, ElasticsearchOptions.BULK_FLUSH_BACKOFF_TYPE_OPTION, ElasticsearchOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION, ElasticsearchOptions.BULK_FLUSH_BACKOFF_DELAY_OPTION, ElasticsearchOptions.CONNECTION_MAX_RETRY_TIMEOUT_OPTION, ElasticsearchOptions.CONNECTION_PATH_PREFIX, ElasticsearchOptions.FORMAT_OPTION).collect(Collectors.toSet());

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        TableSchema tableSchema = context.getCatalogTable().getSchema();
        ElasticsearchValidationUtils.validatePrimaryKey((TableSchema)tableSchema);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        EncodingFormat format = helper.discoverEncodingFormat(SerializationFormatFactory.class, ElasticsearchOptions.FORMAT_OPTION);
        helper.validate();
        Configuration configuration = new Configuration();
        context.getCatalogTable().getOptions().forEach((arg_0, arg_1) -> ((Configuration)configuration).setString(arg_0, arg_1));
        Elasticsearch6Configuration config = new Elasticsearch6Configuration((ReadableConfig)configuration, context.getClassLoader());
        this.validate(config, configuration);
        return new Elasticsearch6DynamicSink((EncodingFormat<SerializationSchema<RowData>>)format, config, TableSchemaUtils.getPhysicalSchema((TableSchema)tableSchema));
    }

    private void validate(Elasticsearch6Configuration config, Configuration originalConfiguration) {
        config.getFailureHandler();
        config.getHosts();
        Elasticsearch6DynamicSinkFactory.validate(config.getIndex().length() >= 1, () -> String.format("'%s' must not be empty", ElasticsearchOptions.INDEX_OPTION.key()));
        int maxActions = config.getBulkFlushMaxActions();
        Elasticsearch6DynamicSinkFactory.validate(maxActions == -1 || maxActions >= 1, () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchOptions.BULK_FLUSH_MAX_ACTIONS_OPTION.key(), maxActions));
        long maxSize = config.getBulkFlushMaxByteSize();
        long mb1 = 0x100000L;
        Elasticsearch6DynamicSinkFactory.validate(maxSize == -1L || maxSize >= mb1 && maxSize % mb1 == 0L, () -> String.format("'%s' must be in MB granularity. Got: %s", ElasticsearchOptions.BULK_FLASH_MAX_SIZE_OPTION.key(), ((MemorySize)originalConfiguration.get(ElasticsearchOptions.BULK_FLASH_MAX_SIZE_OPTION)).toHumanReadableString()));
        Elasticsearch6DynamicSinkFactory.validate(config.getBulkFlushBackoffRetries().map(retries -> retries >= 1).orElse(true), () -> String.format("'%s' must be at least 1. Got: %s", ElasticsearchOptions.BULK_FLUSH_BACKOFF_MAX_RETRIES_OPTION.key(), config.getBulkFlushBackoffRetries().get()));
    }

    private static void validate(boolean condition, Supplier<String> message) {
        if (!condition) {
            throw new ValidationException(message.get());
        }
    }

    public String factoryIdentifier() {
        return "elasticsearch-6";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return requiredOptions;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return optionalOptions;
    }
}

