/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.streaming.connectors.elasticsearch.table.Elasticsearch6Configuration;
import org.apache.flink.streaming.connectors.elasticsearch.table.IndexGeneratorFactory;
import org.apache.flink.streaming.connectors.elasticsearch.table.KeyExtractor;
import org.apache.flink.streaming.connectors.elasticsearch.table.RequestFactory;
import org.apache.flink.streaming.connectors.elasticsearch.table.RowElasticsearchSinkFunction;
import org.apache.flink.streaming.connectors.elasticsearch6.ElasticsearchSink;
import org.apache.flink.streaming.connectors.elasticsearch6.RestClientFactory;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.table.data.RowData;
import org.apache.flink.types.RowKind;
import org.apache.http.HttpHost;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.common.xcontent.XContentType;

@PublicEvolving
final class Elasticsearch6DynamicSink
implements DynamicTableSink {
    @VisibleForTesting
    static final Elasticsearch6RequestFactory REQUEST_FACTORY = new Elasticsearch6RequestFactory();
    private final EncodingFormat<SerializationSchema<RowData>> format;
    private final TableSchema schema;
    private final Elasticsearch6Configuration config;
    private final ElasticSearchBuilderProvider builderProvider;

    public Elasticsearch6DynamicSink(EncodingFormat<SerializationSchema<RowData>> format, Elasticsearch6Configuration config, TableSchema schema) {
        this(format, config, schema, ElasticsearchSink.Builder::new);
    }

    Elasticsearch6DynamicSink(EncodingFormat<SerializationSchema<RowData>> format, Elasticsearch6Configuration config, TableSchema schema, ElasticSearchBuilderProvider builderProvider) {
        this.format = format;
        this.schema = schema;
        this.config = config;
        this.builderProvider = builderProvider;
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        ChangelogMode.Builder builder = ChangelogMode.newBuilder();
        for (RowKind kind : requestedMode.getContainedKinds()) {
            if (kind == RowKind.UPDATE_BEFORE) continue;
            builder.addContainedKind(kind);
        }
        return builder.build();
    }

    public SinkFunctionProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        return () -> {
            SerializationSchema format = (SerializationSchema)this.format.createRuntimeEncoder(context, this.schema.toRowDataType());
            RowElasticsearchSinkFunction upsertFunction = new RowElasticsearchSinkFunction(IndexGeneratorFactory.createIndexGenerator((String)this.config.getIndex(), (TableSchema)this.schema), this.config.getDocumentType(), format, XContentType.JSON, (RequestFactory)REQUEST_FACTORY, KeyExtractor.createKeyExtractor((TableSchema)this.schema, (String)this.config.getKeyDelimiter()));
            ElasticsearchSink.Builder<RowData> builder = this.builderProvider.createBuilder(this.config.getHosts(), upsertFunction);
            builder.setFailureHandler(this.config.getFailureHandler());
            builder.setBulkFlushMaxActions(this.config.getBulkFlushMaxActions());
            builder.setBulkFlushMaxSizeMb((int)(this.config.getBulkFlushMaxByteSize() >> 20));
            builder.setBulkFlushInterval(this.config.getBulkFlushInterval());
            builder.setBulkFlushBackoff(this.config.isBulkFlushBackoffEnabled());
            this.config.getBulkFlushBackoffType().ifPresent(builder::setBulkFlushBackoffType);
            this.config.getBulkFlushBackoffRetries().ifPresent(builder::setBulkFlushBackoffRetries);
            this.config.getBulkFlushBackoffDelay().ifPresent(builder::setBulkFlushBackoffDelay);
            builder.setRestClientFactory(new DefaultRestClientFactory(this.config.getPathPrefix().orElse(null)));
            ElasticsearchSink<RowData> sink = builder.build();
            if (this.config.isDisableFlushOnCheckpoint()) {
                sink.disableFlushOnCheckpoint();
            }
            return sink;
        };
    }

    public DynamicTableSink copy() {
        return this;
    }

    public String asSummaryString() {
        return "Elasticsearch6";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Elasticsearch6DynamicSink that = (Elasticsearch6DynamicSink)o;
        return Objects.equals(this.format, that.format) && Objects.equals(this.schema, that.schema) && Objects.equals((Object)this.config, (Object)that.config) && Objects.equals(this.builderProvider, that.builderProvider);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.format, this.schema, this.config, this.builderProvider});
    }

    private static class Elasticsearch6RequestFactory
    implements RequestFactory {
        private Elasticsearch6RequestFactory() {
        }

        public UpdateRequest createUpdateRequest(String index, String docType, String key, XContentType contentType, byte[] document) {
            return new UpdateRequest(index, docType, key).doc(document, contentType).upsert(document, contentType);
        }

        public IndexRequest createIndexRequest(String index, String docType, String key, XContentType contentType, byte[] document) {
            return new IndexRequest(index, docType, key).source(document, contentType);
        }

        public DeleteRequest createDeleteRequest(String index, String docType, String key) {
            return new DeleteRequest(index, docType, key);
        }
    }

    @VisibleForTesting
    static class DefaultRestClientFactory
    implements RestClientFactory {
        private final String pathPrefix;

        public DefaultRestClientFactory(@Nullable String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        @Override
        public void configureRestClientBuilder(RestClientBuilder restClientBuilder) {
            if (this.pathPrefix != null) {
                restClientBuilder.setPathPrefix(this.pathPrefix);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultRestClientFactory that = (DefaultRestClientFactory)o;
            return Objects.equals(this.pathPrefix, that.pathPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.pathPrefix);
        }
    }

    @FunctionalInterface
    static interface ElasticSearchBuilderProvider {
        public ElasticsearchSink.Builder<RowData> createBuilder(List<HttpHost> var1, RowElasticsearchSinkFunction var2);
    }
}

