/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import java.net.InetSocketAddress;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.buffer.ByteBuf;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelPromise;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.util.concurrent.Future;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4MessageChannelHandler
extends ChannelDuplexHandler {
    private final TransportServiceAdapter transportServiceAdapter;
    private final Netty4Transport transport;
    private final String profileName;

    Netty4MessageChannelHandler(Netty4Transport transport, String profileName) {
        this.transportServiceAdapter = transport.transportServiceAdapter();
        this.transport = transport;
        this.profileName = profileName;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf && this.transportServiceAdapter != null) {
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> this.transportServiceAdapter.addBytesSent(((ByteBuf)msg).readableBytes())));
        }
        ctx.write(msg, promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        Transports.assertTransportThread();
        if (!(msg instanceof ByteBuf)) {
            ctx.fireChannelRead(msg);
            return;
        }
        ByteBuf buffer = (ByteBuf)msg;
        int remainingMessageSize = buffer.getInt(buffer.readerIndex() - 4);
        int expectedReaderIndex = buffer.readerIndex() + remainingMessageSize;
        InetSocketAddress remoteAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        try {
            BytesReference reference = Netty4Utils.toBytesReference(buffer, remainingMessageSize);
            this.transport.messageReceived(reference, ctx.channel(), this.profileName, remoteAddress, remainingMessageSize);
        }
        finally {
            buffer.readerIndex(expectedReaderIndex);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Netty4Utils.maybeDie(cause);
        this.transport.exceptionCaught(ctx, cause);
    }
}

