/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty3;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.transport.netty3.ChannelBufferStreamInput;

final class ChannelBufferBytesReference
extends BytesReference {
    private final ChannelBuffer buffer;
    private final int length;
    private final int offset;

    ChannelBufferBytesReference(ChannelBuffer buffer, int length) {
        this.buffer = buffer;
        this.length = length;
        this.offset = buffer.readerIndex();
        assert (length <= buffer.readableBytes()) : "length[" + length + "] > " + buffer.readableBytes();
    }

    @Override
    public byte get(int index) {
        return this.buffer.getByte(this.offset + index);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        return new ChannelBufferBytesReference(this.buffer.slice(this.offset + from, length), length);
    }

    @Override
    public StreamInput streamInput() {
        return new ChannelBufferStreamInput(this.buffer.duplicate(), this.length);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.buffer.getBytes(this.offset, os, this.length);
    }

    ChannelBuffer toChannelBuffer() {
        return this.buffer.duplicate();
    }

    @Override
    public String utf8ToString() {
        return this.buffer.toString(this.offset, this.length, StandardCharsets.UTF_8);
    }

    @Override
    public BytesRef toBytesRef() {
        if (this.buffer.hasArray()) {
            return new BytesRef(this.buffer.array(), this.buffer.arrayOffset() + this.offset, this.length);
        }
        byte[] copy = new byte[this.length];
        this.buffer.getBytes(this.offset, copy);
        return new BytesRef(copy);
    }

    @Override
    public long ramBytesUsed() {
        return this.buffer.capacity();
    }
}

