/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest.phrase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.CustomAnalyzer;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.suggest.SuggestionBuilder;
import org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.elasticsearch.search.suggest.phrase.DirectCandidateGeneratorBuilder;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestionContext;
import org.elasticsearch.search.suggest.phrase.SmoothingModel;

public class PhraseSuggestionBuilder
extends SuggestionBuilder<PhraseSuggestionBuilder> {
    private static final String SUGGESTION_NAME = "phrase";
    protected static final ParseField MAXERRORS_FIELD = new ParseField("max_errors", new String[0]);
    protected static final ParseField RWE_LIKELIHOOD_FIELD = new ParseField("real_word_error_likelihood", new String[0]);
    protected static final ParseField SEPARATOR_FIELD = new ParseField("separator", new String[0]);
    protected static final ParseField CONFIDENCE_FIELD = new ParseField("confidence", new String[0]);
    protected static final ParseField GRAMSIZE_FIELD = new ParseField("gram_size", new String[0]);
    protected static final ParseField SMOOTHING_MODEL_FIELD = new ParseField("smoothing", new String[0]);
    protected static final ParseField FORCE_UNIGRAM_FIELD = new ParseField("force_unigrams", new String[0]);
    protected static final ParseField TOKEN_LIMIT_FIELD = new ParseField("token_limit", new String[0]);
    protected static final ParseField HIGHLIGHT_FIELD = new ParseField("highlight", new String[0]);
    protected static final ParseField PRE_TAG_FIELD = new ParseField("pre_tag", new String[0]);
    protected static final ParseField POST_TAG_FIELD = new ParseField("post_tag", new String[0]);
    protected static final ParseField COLLATE_FIELD = new ParseField("collate", new String[0]);
    protected static final ParseField COLLATE_QUERY_FIELD = new ParseField("query", new String[0]);
    protected static final ParseField COLLATE_QUERY_PARAMS = new ParseField("params", new String[0]);
    protected static final ParseField COLLATE_QUERY_PRUNE = new ParseField("prune", new String[0]);
    private float maxErrors = 0.5f;
    private String separator = " ";
    private float realWordErrorLikelihood = 0.95f;
    private float confidence = 1.0f;
    private Integer gramSize;
    private boolean forceUnigrams = true;
    private int tokenLimit = 10;
    private String preTag;
    private String postTag;
    private Script collateQuery;
    private Map<String, Object> collateParams;
    private boolean collatePrune = false;
    private SmoothingModel model;
    private final Map<String, List<CandidateGenerator>> generators = new HashMap<String, List<CandidateGenerator>>();

    public PhraseSuggestionBuilder(String field) {
        super(field);
    }

    private PhraseSuggestionBuilder(String fieldname, PhraseSuggestionBuilder in) {
        super(fieldname, in);
        this.maxErrors = in.maxErrors;
        this.separator = in.separator;
        this.realWordErrorLikelihood = in.realWordErrorLikelihood;
        this.confidence = in.confidence;
        this.gramSize = in.gramSize;
        this.forceUnigrams = in.forceUnigrams;
        this.tokenLimit = in.tokenLimit;
        this.preTag = in.preTag;
        this.postTag = in.postTag;
        this.collateQuery = in.collateQuery;
        this.collateParams = in.collateParams;
        this.collatePrune = in.collatePrune;
        this.model = in.model;
        this.generators.putAll(in.generators);
    }

    PhraseSuggestionBuilder(StreamInput in) throws IOException {
        super(in);
        this.maxErrors = in.readFloat();
        this.realWordErrorLikelihood = in.readFloat();
        this.confidence = in.readFloat();
        this.gramSize = in.readOptionalVInt();
        this.model = in.readOptionalNamedWriteable(SmoothingModel.class);
        this.forceUnigrams = in.readBoolean();
        this.tokenLimit = in.readVInt();
        this.preTag = in.readOptionalString();
        this.postTag = in.readOptionalString();
        this.separator = in.readString();
        if (in.readBoolean()) {
            this.collateQuery = new Script(in);
        }
        this.collateParams = in.readMap();
        this.collatePrune = in.readOptionalBoolean();
        int generatorsEntries = in.readVInt();
        for (int i = 0; i < generatorsEntries; ++i) {
            String type = in.readString();
            int numberOfGenerators = in.readVInt();
            ArrayList<DirectCandidateGeneratorBuilder> generatorsList = new ArrayList<DirectCandidateGeneratorBuilder>(numberOfGenerators);
            for (int g = 0; g < numberOfGenerators; ++g) {
                DirectCandidateGeneratorBuilder generator = new DirectCandidateGeneratorBuilder(in);
                generatorsList.add(generator);
            }
            this.generators.put(type, generatorsList);
        }
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeFloat(this.maxErrors);
        out.writeFloat(this.realWordErrorLikelihood);
        out.writeFloat(this.confidence);
        out.writeOptionalVInt(this.gramSize);
        out.writeOptionalNamedWriteable(this.model);
        out.writeBoolean(this.forceUnigrams);
        out.writeVInt(this.tokenLimit);
        out.writeOptionalString(this.preTag);
        out.writeOptionalString(this.postTag);
        out.writeString(this.separator);
        if (this.collateQuery != null) {
            out.writeBoolean(true);
            this.collateQuery.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeMapWithConsistentOrder(this.collateParams);
        out.writeOptionalBoolean(this.collatePrune);
        out.writeVInt(this.generators.size());
        for (Map.Entry<String, List<CandidateGenerator>> entry : this.generators.entrySet()) {
            out.writeString(entry.getKey());
            List<CandidateGenerator> generatorsList = entry.getValue();
            out.writeVInt(generatorsList.size());
            for (CandidateGenerator generator : generatorsList) {
                generator.writeTo(out);
            }
        }
    }

    public PhraseSuggestionBuilder gramSize(int gramSize) {
        if (gramSize < 1) {
            throw new IllegalArgumentException("gramSize must be >= 1");
        }
        this.gramSize = gramSize;
        return this;
    }

    public Integer gramSize() {
        return this.gramSize;
    }

    public PhraseSuggestionBuilder maxErrors(float maxErrors) {
        if ((double)maxErrors <= 0.0) {
            throw new IllegalArgumentException("max_error must be > 0.0");
        }
        this.maxErrors = maxErrors;
        return this;
    }

    public Float maxErrors() {
        return Float.valueOf(this.maxErrors);
    }

    public PhraseSuggestionBuilder separator(String separator) {
        Objects.requireNonNull(separator, "separator cannot be set to null");
        this.separator = separator;
        return this;
    }

    public String separator() {
        return this.separator;
    }

    public PhraseSuggestionBuilder realWordErrorLikelihood(float realWordErrorLikelihood) {
        if ((double)realWordErrorLikelihood <= 0.0) {
            throw new IllegalArgumentException("real_word_error_likelihood must be > 0.0");
        }
        this.realWordErrorLikelihood = realWordErrorLikelihood;
        return this;
    }

    public Float realWordErrorLikelihood() {
        return Float.valueOf(this.realWordErrorLikelihood);
    }

    public PhraseSuggestionBuilder confidence(float confidence) {
        if ((double)confidence < 0.0) {
            throw new IllegalArgumentException("confidence must be >= 0.0");
        }
        this.confidence = confidence;
        return this;
    }

    public Float confidence() {
        return Float.valueOf(this.confidence);
    }

    public PhraseSuggestionBuilder addCandidateGenerator(CandidateGenerator generator) {
        List<CandidateGenerator> list = this.generators.get(generator.getType());
        if (list == null) {
            list = new ArrayList<CandidateGenerator>();
            this.generators.put(generator.getType(), list);
        }
        list.add(generator);
        return this;
    }

    public PhraseSuggestionBuilder clearCandidateGenerators() {
        this.generators.clear();
        return this;
    }

    public PhraseSuggestionBuilder forceUnigrams(boolean forceUnigrams) {
        this.forceUnigrams = forceUnigrams;
        return this;
    }

    public Boolean forceUnigrams() {
        return this.forceUnigrams;
    }

    public PhraseSuggestionBuilder smoothingModel(SmoothingModel model) {
        this.model = model;
        return this;
    }

    public SmoothingModel smoothingModel() {
        return this.model;
    }

    public PhraseSuggestionBuilder tokenLimit(int tokenLimit) {
        if (tokenLimit <= 0) {
            throw new IllegalArgumentException("token_limit must be >= 1");
        }
        this.tokenLimit = tokenLimit;
        return this;
    }

    public Integer tokenLimit() {
        return this.tokenLimit;
    }

    public PhraseSuggestionBuilder highlight(String preTag, String postTag) {
        if (preTag == null != (postTag == null)) {
            throw new IllegalArgumentException("Pre and post tag must both be null or both not be null.");
        }
        this.preTag = preTag;
        this.postTag = postTag;
        return this;
    }

    public String preTag() {
        return this.preTag;
    }

    public String postTag() {
        return this.postTag;
    }

    public PhraseSuggestionBuilder collateQuery(String collateQuery) {
        this.collateQuery = new Script(ScriptType.INLINE, "mustache", collateQuery, Collections.emptyMap());
        return this;
    }

    public PhraseSuggestionBuilder collateQuery(Script collateQueryTemplate) {
        this.collateQuery = collateQueryTemplate;
        return this;
    }

    public Script collateQuery() {
        return this.collateQuery;
    }

    public PhraseSuggestionBuilder collateParams(Map<String, Object> collateParams) {
        Objects.requireNonNull(collateParams, "collate parameters cannot be null.");
        this.collateParams = new HashMap<String, Object>(collateParams);
        return this;
    }

    public Map<String, Object> collateParams() {
        return this.collateParams;
    }

    public PhraseSuggestionBuilder collatePrune(boolean collatePrune) {
        this.collatePrune = collatePrune;
        return this;
    }

    public Boolean collatePrune() {
        return this.collatePrune;
    }

    @Override
    public XContentBuilder innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RWE_LIKELIHOOD_FIELD.getPreferredName(), this.realWordErrorLikelihood);
        builder.field(CONFIDENCE_FIELD.getPreferredName(), this.confidence);
        builder.field(SEPARATOR_FIELD.getPreferredName(), this.separator);
        builder.field(MAXERRORS_FIELD.getPreferredName(), this.maxErrors);
        if (this.gramSize != null) {
            builder.field(GRAMSIZE_FIELD.getPreferredName(), this.gramSize);
        }
        builder.field(FORCE_UNIGRAM_FIELD.getPreferredName(), this.forceUnigrams);
        builder.field(TOKEN_LIMIT_FIELD.getPreferredName(), this.tokenLimit);
        if (!this.generators.isEmpty()) {
            Set<Map.Entry<String, List<CandidateGenerator>>> entrySet = this.generators.entrySet();
            for (Map.Entry<String, List<CandidateGenerator>> entry : entrySet) {
                builder.startArray(entry.getKey());
                for (CandidateGenerator generator : entry.getValue()) {
                    generator.toXContent(builder, params);
                }
                builder.endArray();
            }
        }
        if (this.model != null) {
            builder.startObject(SMOOTHING_MODEL_FIELD.getPreferredName());
            this.model.toXContent(builder, params);
            builder.endObject();
        }
        if (this.preTag != null) {
            builder.startObject(HIGHLIGHT_FIELD.getPreferredName());
            builder.field(PRE_TAG_FIELD.getPreferredName(), this.preTag);
            builder.field(POST_TAG_FIELD.getPreferredName(), this.postTag);
            builder.endObject();
        }
        if (this.collateQuery != null) {
            builder.startObject(COLLATE_FIELD.getPreferredName());
            builder.field(COLLATE_QUERY_FIELD.getPreferredName(), this.collateQuery);
            if (this.collateParams != null) {
                builder.field(COLLATE_QUERY_PARAMS.getPreferredName(), this.collateParams);
            }
            builder.field(COLLATE_QUERY_PRUNE.getPreferredName(), this.collatePrune);
            builder.endObject();
        }
        return builder;
    }

    static PhraseSuggestionBuilder innerFromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        PhraseSuggestionBuilder tmpSuggestion = new PhraseSuggestionBuilder("_na_");
        ParseFieldMatcher parseFieldMatcher = parseContext.getParseFieldMatcher();
        String currentFieldName = null;
        String fieldname = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (parseFieldMatcher.match(currentFieldName, SuggestionBuilder.ANALYZER_FIELD)) {
                    tmpSuggestion.analyzer(parser.text());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, SuggestionBuilder.FIELDNAME_FIELD)) {
                    fieldname = parser.text();
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, SuggestionBuilder.SIZE_FIELD)) {
                    tmpSuggestion.size(parser.intValue());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, SuggestionBuilder.SHARDSIZE_FIELD)) {
                    tmpSuggestion.shardSize(parser.intValue());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, RWE_LIKELIHOOD_FIELD)) {
                    tmpSuggestion.realWordErrorLikelihood(parser.floatValue());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, CONFIDENCE_FIELD)) {
                    tmpSuggestion.confidence(parser.floatValue());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, SEPARATOR_FIELD)) {
                    tmpSuggestion.separator(parser.text());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, MAXERRORS_FIELD)) {
                    tmpSuggestion.maxErrors(parser.floatValue());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, GRAMSIZE_FIELD)) {
                    tmpSuggestion.gramSize(parser.intValue());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, FORCE_UNIGRAM_FIELD)) {
                    tmpSuggestion.forceUnigrams(parser.booleanValue());
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, TOKEN_LIMIT_FIELD)) {
                    tmpSuggestion.tokenLimit(parser.intValue());
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "suggester[phrase] doesn't support field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (parseFieldMatcher.match(currentFieldName, DirectCandidateGeneratorBuilder.DIRECT_GENERATOR_FIELD)) {
                    while ((token = parser.nextToken()) == XContentParser.Token.START_OBJECT) {
                        tmpSuggestion.addCandidateGenerator(DirectCandidateGeneratorBuilder.fromXContent(parseContext));
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "suggester[phrase]  doesn't support array field [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (parseFieldMatcher.match(currentFieldName, SMOOTHING_MODEL_FIELD)) {
                    PhraseSuggestionBuilder.ensureNoSmoothing(tmpSuggestion);
                    tmpSuggestion.smoothingModel(SmoothingModel.fromXContent(parseContext));
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, HIGHLIGHT_FIELD)) {
                    String preTag = null;
                    String postTag = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (!token.isValue()) continue;
                        if (parseFieldMatcher.match(currentFieldName, PRE_TAG_FIELD)) {
                            preTag = parser.text();
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, POST_TAG_FIELD)) {
                            postTag = parser.text();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "suggester[phrase][highlight] doesn't support field [" + currentFieldName + "]", new Object[0]);
                    }
                    tmpSuggestion.highlight(preTag, postTag);
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, COLLATE_FIELD)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, COLLATE_QUERY_FIELD)) {
                            if (tmpSuggestion.collateQuery() != null) {
                                throw new ParsingException(parser.getTokenLocation(), "suggester[phrase][collate] query already set, doesn't support additional [" + currentFieldName + "]", new Object[0]);
                            }
                            Script template = Script.parse(parser, parseFieldMatcher, "mustache");
                            tmpSuggestion.collateQuery(template);
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, COLLATE_QUERY_PARAMS)) {
                            tmpSuggestion.collateParams(parser.map());
                            continue;
                        }
                        if (parseFieldMatcher.match(currentFieldName, COLLATE_QUERY_PRUNE)) {
                            if (parser.isBooleanValue()) {
                                tmpSuggestion.collatePrune(parser.booleanValue());
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "suggester[phrase][collate] prune must be either 'true' or 'false'", new Object[0]);
                        }
                        throw new ParsingException(parser.getTokenLocation(), "suggester[phrase][collate] doesn't support field [" + currentFieldName + "]", new Object[0]);
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "suggester[phrase]  doesn't support array field [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "suggester[phrase] doesn't support field [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldname == null) {
            throw new ElasticsearchParseException("the required field option [" + FIELDNAME_FIELD.getPreferredName() + "] is missing", new Object[0]);
        }
        return new PhraseSuggestionBuilder(fieldname, tmpSuggestion);
    }

    @Override
    public SuggestionSearchContext.SuggestionContext build(QueryShardContext context) throws IOException {
        PhraseSuggestionContext suggestionContext = new PhraseSuggestionContext(context);
        MapperService mapperService = context.getMapperService();
        this.populateCommonFields(mapperService, suggestionContext);
        suggestionContext.setSeparator(BytesRefs.toBytesRef(this.separator));
        suggestionContext.setRealWordErrorLikelihood(Float.valueOf(this.realWordErrorLikelihood));
        suggestionContext.setConfidence(this.confidence);
        suggestionContext.setMaxErrors(Float.valueOf(this.maxErrors));
        suggestionContext.setSeparator(BytesRefs.toBytesRef(this.separator));
        suggestionContext.setRequireUnigram(this.forceUnigrams);
        suggestionContext.setTokenLimit(this.tokenLimit);
        suggestionContext.setPreTag(BytesRefs.toBytesRef(this.preTag));
        suggestionContext.setPostTag(BytesRefs.toBytesRef(this.postTag));
        if (this.gramSize != null) {
            suggestionContext.setGramSize(this.gramSize);
        }
        for (List<CandidateGenerator> candidateGenerators : this.generators.values()) {
            for (CandidateGenerator candidateGenerator : candidateGenerators) {
                suggestionContext.addGenerator(candidateGenerator.build(mapperService));
            }
        }
        if (this.model != null) {
            suggestionContext.setModel(this.model.buildWordScorerFactory());
        }
        if (this.collateQuery != null) {
            Function<Map<String, Object>, ExecutableScript> compiledScript = context.getLazyExecutableScript(this.collateQuery, ScriptContext.Standard.SEARCH);
            suggestionContext.setCollateQueryScript(compiledScript);
            if (this.collateParams != null) {
                suggestionContext.setCollateScriptParams(this.collateParams);
            }
            suggestionContext.setCollatePrune(this.collatePrune);
        }
        if (this.gramSize == null || suggestionContext.generators().isEmpty()) {
            ShingleTokenFilterFactory.Factory shingleFilterFactory = PhraseSuggestionBuilder.getShingleFilterFactory(suggestionContext.getAnalyzer());
            if (this.gramSize == null && shingleFilterFactory != null) {
                suggestionContext.setGramSize(shingleFilterFactory.getMaxShingleSize());
                if (suggestionContext.getAnalyzer() == null && shingleFilterFactory.getMinShingleSize() > 1 && !shingleFilterFactory.getOutputUnigrams()) {
                    throw new IllegalArgumentException("The default analyzer for field: [" + suggestionContext.getField() + "] doesn't emit unigrams. If this is intentional try to set the analyzer explicitly");
                }
            }
            if (suggestionContext.generators().isEmpty()) {
                if (shingleFilterFactory != null && shingleFilterFactory.getMinShingleSize() > 1 && !shingleFilterFactory.getOutputUnigrams() && suggestionContext.getRequireUnigram()) {
                    throw new IllegalArgumentException("The default candidate generator for phrase suggest can't operate on field: [" + suggestionContext.getField() + "] since it doesn't emit unigrams. If this is intentional try to set the candidate generator field explicitly");
                }
                PhraseSuggestionContext.DirectCandidateGenerator generator = new PhraseSuggestionContext.DirectCandidateGenerator();
                generator.setField(suggestionContext.getField());
                suggestionContext.addGenerator(generator);
            }
        }
        return suggestionContext;
    }

    private static ShingleTokenFilterFactory.Factory getShingleFilterFactory(Analyzer analyzer) {
        if (analyzer instanceof NamedAnalyzer) {
            analyzer = ((NamedAnalyzer)analyzer).analyzer();
        }
        if (analyzer instanceof CustomAnalyzer) {
            TokenFilterFactory[] tokenFilters;
            CustomAnalyzer a = (CustomAnalyzer)analyzer;
            for (TokenFilterFactory tokenFilterFactory : tokenFilters = a.tokenFilters()) {
                if (tokenFilterFactory instanceof ShingleTokenFilterFactory) {
                    return ((ShingleTokenFilterFactory)tokenFilterFactory).getInnerFactory();
                }
                if (!(tokenFilterFactory instanceof ShingleTokenFilterFactory.Factory)) continue;
                return (ShingleTokenFilterFactory.Factory)tokenFilterFactory;
            }
        }
        return null;
    }

    private static void ensureNoSmoothing(PhraseSuggestionBuilder suggestion) {
        if (suggestion.smoothingModel() != null) {
            throw new IllegalArgumentException("only one smoothing model supported");
        }
    }

    @Override
    public String getWriteableName() {
        return SUGGESTION_NAME;
    }

    @Override
    protected boolean doEquals(PhraseSuggestionBuilder other) {
        return Objects.equals(Float.valueOf(this.maxErrors), Float.valueOf(other.maxErrors)) && Objects.equals(this.separator, other.separator) && Objects.equals(Float.valueOf(this.realWordErrorLikelihood), Float.valueOf(other.realWordErrorLikelihood)) && Objects.equals(Float.valueOf(this.confidence), Float.valueOf(other.confidence)) && Objects.equals(this.generators, other.generators) && Objects.equals(this.gramSize, other.gramSize) && Objects.equals(this.model, other.model) && Objects.equals(this.forceUnigrams, other.forceUnigrams) && Objects.equals(this.tokenLimit, other.tokenLimit) && Objects.equals(this.preTag, other.preTag) && Objects.equals(this.postTag, other.postTag) && Objects.equals(this.collateQuery, other.collateQuery) && Objects.equals(this.collateParams, other.collateParams) && Objects.equals(this.collatePrune, other.collatePrune);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Float.valueOf(this.maxErrors), this.separator, Float.valueOf(this.realWordErrorLikelihood), Float.valueOf(this.confidence), this.generators, this.gramSize, this.model, this.forceUnigrams, this.tokenLimit, this.preTag, this.postTag, this.collateQuery, this.collateParams, this.collatePrune);
    }

    public static interface CandidateGenerator
    extends Writeable,
    ToXContent {
        public String getType();

        public PhraseSuggestionContext.DirectCandidateGenerator build(MapperService var1) throws IOException;
    }
}

