/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.com.carrotsearch.hppc.DoubleArrayList;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesMethod;
import org.elasticsearch.search.aggregations.support.AbstractValuesSourceParser;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.aggregations.support.XContentParseContext;

public abstract class AbstractPercentilesParser
extends AbstractValuesSourceParser.NumericValuesSourceParser {
    public static final ParseField KEYED_FIELD = new ParseField("keyed", new String[0]);
    public static final ParseField METHOD_FIELD = new ParseField("method", new String[0]);
    public static final ParseField COMPRESSION_FIELD = new ParseField("compression", new String[0]);
    public static final ParseField NUMBER_SIGNIFICANT_DIGITS_FIELD = new ParseField("number_of_significant_value_digits", new String[0]);

    public AbstractPercentilesParser(boolean formattable) {
        super(true, formattable, false);
    }

    @Override
    protected boolean token(String aggregationName, String currentFieldName, XContentParser.Token token, XContentParseContext context, Map<ParseField, Object> otherOptions) throws IOException {
        XContentParser parser = context.getParser();
        if (token == XContentParser.Token.START_ARRAY) {
            if (context.matchField(currentFieldName, this.keysField())) {
                DoubleArrayList values = new DoubleArrayList(10);
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    double value = parser.doubleValue();
                    values.add(value);
                }
                double[] keys = values.toArray();
                otherOptions.put(this.keysField(), keys);
                return true;
            }
            return false;
        }
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            if (context.matchField(currentFieldName, KEYED_FIELD)) {
                boolean keyed = parser.booleanValue();
                otherOptions.put(KEYED_FIELD, keyed);
                return true;
            }
            return false;
        }
        if (token == XContentParser.Token.START_OBJECT) {
            PercentilesMethod method = PercentilesMethod.resolveFromName(currentFieldName);
            if (method == null) {
                return false;
            }
            otherOptions.put(METHOD_FIELD, method);
            switch (method) {
                case TDIGEST: {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            if (context.matchField(currentFieldName, COMPRESSION_FIELD)) {
                                double compression = parser.doubleValue();
                                otherOptions.put(COMPRESSION_FIELD, compression);
                                continue;
                            }
                            return false;
                        }
                        return false;
                    }
                    break;
                }
                case HDR: {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            if (context.matchField(currentFieldName, NUMBER_SIGNIFICANT_DIGITS_FIELD)) {
                                int numberOfSignificantValueDigits = parser.intValue();
                                otherOptions.put(NUMBER_SIGNIFICANT_DIGITS_FIELD, numberOfSignificantValueDigits);
                                continue;
                            }
                            return false;
                        }
                        return false;
                    }
                    break;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected ValuesSourceAggregationBuilder<ValuesSource.Numeric, ?> createFactory(String aggregationName, ValuesSourceType valuesSourceType, ValueType targetValueType, Map<ParseField, Object> otherOptions) {
        PercentilesMethod method = (PercentilesMethod)otherOptions.getOrDefault(METHOD_FIELD, PercentilesMethod.TDIGEST);
        double[] cdfValues = (double[])otherOptions.get(this.keysField());
        Double compression = (Double)otherOptions.get(COMPRESSION_FIELD);
        Integer numberOfSignificantValueDigits = (Integer)otherOptions.get(NUMBER_SIGNIFICANT_DIGITS_FIELD);
        Boolean keyed = (Boolean)otherOptions.get(KEYED_FIELD);
        return this.buildFactory(aggregationName, cdfValues, method, compression, numberOfSignificantValueDigits, keyed);
    }

    protected abstract ValuesSourceAggregationBuilder<ValuesSource.Numeric, ?> buildFactory(String var1, double[] var2, PercentilesMethod var3, Double var4, Integer var5, Boolean var6);

    protected abstract ParseField keysField();
}

