/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

class HistogramAggregator
extends BucketsAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final double interval;
    private final double offset;
    private final InternalOrder order;
    private final boolean keyed;
    private final long minDocCount;
    private final double minBound;
    private final double maxBound;
    private final LongHash bucketOrds;

    public HistogramAggregator(String name, AggregatorFactories factories, double interval, double offset, InternalOrder order, boolean keyed, long minDocCount, double minBound, double maxBound, @Nullable ValuesSource.Numeric valuesSource, DocValueFormat formatter, AggregationContext aggregationContext, Aggregator parent, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, pipelineAggregators, metaData);
        if (interval <= 0.0) {
            throw new IllegalArgumentException("interval must be positive, got: " + interval);
        }
        this.interval = interval;
        this.offset = offset;
        this.order = order;
        this.keyed = keyed;
        this.minDocCount = minDocCount;
        this.minBound = minBound;
        this.maxBound = maxBound;
        this.valuesSource = valuesSource;
        this.formatter = formatter;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final SortedNumericDoubleValues values = this.valuesSource.doubleValues(ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                values.setDocument(doc);
                int valuesCount = values.count();
                double previousKey = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < valuesCount; ++i) {
                    double value = values.valueAt(i);
                    double key = Math.floor((value - HistogramAggregator.this.offset) / HistogramAggregator.this.interval);
                    assert (key >= previousKey);
                    if (key == previousKey) continue;
                    long bucketOrd = HistogramAggregator.this.bucketOrds.add(Double.doubleToLongBits(key));
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        HistogramAggregator.this.collectExistingBucket(sub, doc, bucketOrd);
                    } else {
                        HistogramAggregator.this.collectBucket(sub, doc, bucketOrd);
                    }
                    previousKey = key;
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long bucket) throws IOException {
        assert (bucket == 0L);
        ArrayList<InternalHistogram.Bucket> buckets = new ArrayList<InternalHistogram.Bucket>((int)this.bucketOrds.size());
        for (long i = 0L; i < this.bucketOrds.size(); ++i) {
            double roundKey = Double.longBitsToDouble(this.bucketOrds.get(i));
            double key = roundKey * this.interval + this.offset;
            buckets.add(new InternalHistogram.Bucket(key, this.bucketDocCount(i), this.keyed, this.formatter, this.bucketAggregations(i)));
        }
        CollectionUtil.introSort(buckets, InternalOrder.KEY_ASC.comparator());
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = null;
        if (this.minDocCount == 0L) {
            emptyBucketInfo = new InternalHistogram.EmptyBucketInfo(this.interval, this.offset, this.minBound, this.maxBound, this.buildEmptySubAggregations());
        }
        return new InternalHistogram(this.name, buckets, this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        InternalHistogram.EmptyBucketInfo emptyBucketInfo = null;
        if (this.minDocCount == 0L) {
            emptyBucketInfo = new InternalHistogram.EmptyBucketInfo(this.interval, this.offset, this.minBound, this.maxBound, this.buildEmptySubAggregations());
        }
        return new InternalHistogram(this.name, Collections.emptyList(), this.order, this.minDocCount, emptyBucketInfo, this.formatter, this.keyed, this.pipelineAggregators(), this.metaData());
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

