/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.ParseFieldMatcherSupplier;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.elasticsearch.rest.action.search.RestSearchAction;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.search.SearchRequestParsers;

public class RestSearchTemplateAction
extends BaseRestHandler {
    private static ObjectParser<SearchTemplateRequest, ParseFieldMatcherSupplier> PARSER = new ObjectParser("search_template");
    private final SearchRequestParsers searchRequestParsers;

    @Inject
    public RestSearchTemplateAction(Settings settings, RestController controller, SearchRequestParsers searchRequestParsers) {
        super(settings);
        this.searchRequestParsers = searchRequestParsers;
        controller.registerHandler(RestRequest.Method.GET, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/template", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!RestActions.hasBodyContent(request)) {
            throw new ElasticsearchException("request body is required", new Object[0]);
        }
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest(searchRequest, request, this.searchRequestParsers, this.parseFieldMatcher, null);
        SearchTemplateRequest searchTemplateRequest = RestSearchTemplateAction.parse(RestActions.getRestContent(request));
        searchTemplateRequest.setRequest(searchRequest);
        return channel -> client.execute(SearchTemplateAction.INSTANCE, searchTemplateRequest, new RestStatusToXContentListener(channel));
    }

    public static SearchTemplateRequest parse(BytesReference bytes) throws IOException {
        try (XContentParser parser = XContentHelper.createParser(bytes);){
            SearchTemplateRequest searchTemplateRequest = PARSER.parse(parser, new SearchTemplateRequest(), () -> ParseFieldMatcher.STRICT);
            return searchTemplateRequest;
        }
    }

    static {
        PARSER.declareField((parser, request, s) -> request.setScriptParams(parser.map()), new ParseField("params", new String[0]), ObjectParser.ValueType.OBJECT);
        PARSER.declareString((request, s) -> {
            request.setScriptType(ScriptType.FILE);
            request.setScript((String)s);
        }, new ParseField("file", new String[0]));
        PARSER.declareString((request, s) -> {
            request.setScriptType(ScriptType.STORED);
            request.setScript((String)s);
        }, new ParseField("id", new String[0]));
        PARSER.declareBoolean(SearchTemplateRequest::setExplain, new ParseField("explain", new String[0]));
        PARSER.declareBoolean(SearchTemplateRequest::setProfile, new ParseField("profile", new String[0]));
        PARSER.declareField((parser, request, value) -> {
            block15: {
                request.setScriptType(ScriptType.INLINE);
                if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    try (XContentBuilder builder = XContentFactory.contentBuilder(parser.contentType());){
                        request.setScript(builder.copyCurrentStructure(parser).bytes().utf8ToString());
                        break block15;
                    }
                    catch (IOException e) {
                        throw new ParsingException(parser.getTokenLocation(), "Could not parse inline template", e, new Object[0]);
                    }
                }
                request.setScript(parser.text());
            }
        }, new ParseField("inline", "template"), ObjectParser.ValueType.OBJECT_OR_STRING);
    }
}

