/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.mustache;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.ScriptPlugin;
import org.elasticsearch.plugins.SearchPlugin;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.mustache.MultiSearchTemplateAction;
import org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.elasticsearch.script.mustache.MultiSearchTemplateResponse;
import org.elasticsearch.script.mustache.MustacheScriptEngineService;
import org.elasticsearch.script.mustache.RestDeleteSearchTemplateAction;
import org.elasticsearch.script.mustache.RestGetSearchTemplateAction;
import org.elasticsearch.script.mustache.RestMultiSearchTemplateAction;
import org.elasticsearch.script.mustache.RestPutSearchTemplateAction;
import org.elasticsearch.script.mustache.RestRenderSearchTemplateAction;
import org.elasticsearch.script.mustache.RestSearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateAction;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.elasticsearch.script.mustache.TemplateQueryBuilder;
import org.elasticsearch.script.mustache.TransportMultiSearchTemplateAction;
import org.elasticsearch.script.mustache.TransportSearchTemplateAction;

public class MustachePlugin
extends Plugin
implements ScriptPlugin,
ActionPlugin,
SearchPlugin {
    @Override
    public ScriptEngineService getScriptEngineService(Settings settings) {
        return new MustacheScriptEngineService(settings);
    }

    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler<SearchTemplateRequest, SearchTemplateResponse>(SearchTemplateAction.INSTANCE, TransportSearchTemplateAction.class, new Class[0]), new ActionPlugin.ActionHandler<MultiSearchTemplateRequest, MultiSearchTemplateResponse>(MultiSearchTemplateAction.INSTANCE, TransportMultiSearchTemplateAction.class, new Class[0]));
    }

    @Override
    public List<SearchPlugin.QuerySpec<?>> getQueries() {
        return Collections.singletonList(new SearchPlugin.QuerySpec<TemplateQueryBuilder>("template", TemplateQueryBuilder::new, TemplateQueryBuilder::fromXContent));
    }

    @Override
    public List<Class<? extends RestHandler>> getRestHandlers() {
        return Arrays.asList(RestSearchTemplateAction.class, RestMultiSearchTemplateAction.class, RestGetSearchTemplateAction.class, RestPutSearchTemplateAction.class, RestDeleteSearchTemplateAction.class, RestRenderSearchTemplateAction.class);
    }
}

