/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.tasks.TaskId;

public class DeleteByQueryRequest
extends AbstractBulkByScrollRequest<DeleteByQueryRequest>
implements IndicesRequest.Replaceable {
    public DeleteByQueryRequest() {
    }

    public DeleteByQueryRequest(SearchRequest search) {
        this(search, true);
    }

    private DeleteByQueryRequest(SearchRequest search, boolean setDefaults) {
        super(search, setDefaults);
        if (setDefaults) {
            search.source().fetchSource(false);
        }
    }

    @Override
    protected DeleteByQueryRequest self() {
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = super.validate();
        if (this.getSearchRequest().indices() == null || this.getSearchRequest().indices().length == 0) {
            e = ValidateActions.addValidationError("use _all if you really want to delete from all existing indexes", e);
        }
        if (this.getSearchRequest() == null || this.getSearchRequest().source() == null) {
            e = ValidateActions.addValidationError("source is missing", e);
        }
        return e;
    }

    @Override
    DeleteByQueryRequest forSlice(TaskId slicingTask, SearchRequest slice) {
        return this.doForSlice(new DeleteByQueryRequest(slice, false), slicingTask);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("delete-by-query ");
        this.searchToString(b);
        return b.toString();
    }

    @Override
    public IndicesRequest indices(String ... indices) {
        assert (this.getSearchRequest() != null);
        this.getSearchRequest().indices(indices);
        return this;
    }

    @Override
    public String[] indices() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        assert (this.getSearchRequest() != null);
        return this.getSearchRequest().indicesOptions();
    }
}

