/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.bulk.Retry;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.BulkIndexByScrollResponse;
import org.elasticsearch.index.reindex.ClientScrollableHitSource;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkingBulkByScrollTask;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class AbstractAsyncBulkByScrollAction<Request extends AbstractBulkByScrollRequest<Request>> {
    protected final Logger logger;
    protected final WorkingBulkByScrollTask task;
    protected final ThreadPool threadPool;
    protected final Request mainRequest;
    private final AtomicLong startTime = new AtomicLong(-1L);
    private final Set<String> destinationIndices = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ParentTaskAssigningClient client;
    private final ActionListener<BulkIndexByScrollResponse> listener;
    private final Retry bulkRetry;
    private final ScrollableHitSource scrollSource;

    public AbstractAsyncBulkByScrollAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, Request mainRequest, ActionListener<BulkIndexByScrollResponse> listener) {
        this.task = task;
        this.logger = logger;
        this.client = client;
        this.threadPool = threadPool;
        this.mainRequest = mainRequest;
        this.listener = listener;
        BackoffPolicy backoffPolicy = this.buildBackoffPolicy();
        this.bulkRetry = Retry.on(EsRejectedExecutionException.class).policy(BackoffPolicy.wrap(backoffPolicy, task::countBulkRetry));
        this.scrollSource = this.buildScrollableResultSource(backoffPolicy);
        List<SortBuilder<?>> sorts = ((AbstractBulkByScrollRequest)mainRequest).getSearchRequest().source().sorts();
        if (sorts == null || sorts.isEmpty()) {
            ((AbstractBulkByScrollRequest)mainRequest).getSearchRequest().source().sort(SortBuilders.fieldSort("_doc"));
        }
        ((AbstractBulkByScrollRequest)mainRequest).getSearchRequest().source().version(this.needsSourceDocumentVersions());
    }

    protected abstract boolean needsSourceDocumentVersions();

    protected abstract BulkRequest buildBulk(Iterable<? extends ScrollableHitSource.Hit> var1);

    protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy) {
        return new ClientScrollableHitSource(this.logger, backoffPolicy, this.threadPool, this.task::countSearchRetry, this::finishHim, this.client, ((AbstractBulkByScrollRequest)this.mainRequest).getSearchRequest());
    }

    protected BulkIndexByScrollResponse buildResponse(TimeValue took, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        return new BulkIndexByScrollResponse(took, this.task.getStatus(), indexingFailures, searchFailures, timedOut);
    }

    public void start() {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        try {
            this.startTime.set(System.nanoTime());
            this.scrollSource.start(response -> this.onScrollResponse(TimeValue.timeValueNanos(System.nanoTime()), 0, (ScrollableHitSource.Response)response));
        }
        catch (Exception e) {
            this.finishHim(e);
        }
    }

    void onScrollResponse(TimeValue lastBatchStartTime, int lastBatchSize, final ScrollableHitSource.Response response) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        if (response.getFailures().size() > 0 || response.isTimedOut()) {
            this.refreshAndFinish(Collections.emptyList(), response.getFailures(), response.isTimedOut());
            return;
        }
        long total = response.getTotalHits();
        if (((AbstractBulkByScrollRequest)this.mainRequest).getSize() > 0) {
            total = Math.min(total, (long)((AbstractBulkByScrollRequest)this.mainRequest).getSize());
        }
        this.task.setTotal(total);
        AbstractRunnable prepareBulkRequestRunnable = new AbstractRunnable(){

            @Override
            protected void doRun() throws Exception {
                AbstractAsyncBulkByScrollAction.this.prepareBulkRequest(TimeValue.timeValueNanos(System.nanoTime()), response);
            }

            @Override
            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        };
        prepareBulkRequestRunnable = (AbstractRunnable)this.threadPool.getThreadContext().preserveContext(prepareBulkRequestRunnable);
        this.task.delayPrepareBulkRequest(this.threadPool, lastBatchStartTime, lastBatchSize, prepareBulkRequestRunnable);
    }

    void prepareBulkRequest(TimeValue thisBatchStartTime, ScrollableHitSource.Response response) {
        BulkRequest request;
        long remaining;
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        if (response.getHits().isEmpty()) {
            this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
            return;
        }
        this.task.countBatch();
        List<? extends ScrollableHitSource.Hit> hits = response.getHits();
        if (((AbstractBulkByScrollRequest)this.mainRequest).getSize() != -1 && (remaining = Math.max(0L, (long)((AbstractBulkByScrollRequest)this.mainRequest).getSize() - this.task.getSuccessfullyProcessed())) < (long)hits.size()) {
            hits = hits.subList(0, (int)remaining);
        }
        if ((request = this.buildBulk(hits)).requests().isEmpty()) {
            this.startNextScroll(thisBatchStartTime, 0);
            return;
        }
        request.timeout(((AbstractBulkByScrollRequest)this.mainRequest).getTimeout());
        request.waitForActiveShards(((AbstractBulkByScrollRequest)this.mainRequest).getWaitForActiveShards());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending [{}] entry, [{}] bulk request", (Object)request.requests().size(), (Object)new ByteSizeValue(request.estimatedSizeInBytes()));
        }
        this.sendBulkRequest(thisBatchStartTime, request);
    }

    void sendBulkRequest(final TimeValue thisBatchStartTime, BulkRequest request) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        this.bulkRetry.withAsyncBackoff(this.client, request, new ActionListener<BulkResponse>(){

            @Override
            public void onResponse(BulkResponse response) {
                AbstractAsyncBulkByScrollAction.this.onBulkResponse(thisBatchStartTime, response);
            }

            @Override
            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    void onBulkResponse(TimeValue thisBatchStartTime, BulkResponse response) {
        try {
            ArrayList<BulkItemResponse.Failure> failures = new ArrayList<BulkItemResponse.Failure>();
            HashSet<String> destinationIndicesThisBatch = new HashSet<String>();
            for (BulkItemResponse item : response) {
                if (item.isFailed()) {
                    this.recordFailure(item.getFailure(), failures);
                    continue;
                }
                switch (item.getOpType()) {
                    case "index": 
                    case "create": {
                        IndexResponse ir = (IndexResponse)item.getResponse();
                        if (ir.getResult() == DocWriteResponse.Result.CREATED) {
                            this.task.countCreated();
                            break;
                        }
                        this.task.countUpdated();
                        break;
                    }
                    case "delete": {
                        this.task.countDeleted();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown op type:  " + item.getOpType());
                    }
                }
                destinationIndicesThisBatch.add(item.getIndex());
            }
            if (this.task.isCancelled()) {
                this.finishHim(null);
                return;
            }
            this.addDestinationIndices(destinationIndicesThisBatch);
            if (!failures.isEmpty()) {
                this.refreshAndFinish(Collections.unmodifiableList(failures), Collections.emptyList(), false);
                return;
            }
            if (((AbstractBulkByScrollRequest)this.mainRequest).getSize() != -1 && this.task.getSuccessfullyProcessed() >= (long)((AbstractBulkByScrollRequest)this.mainRequest).getSize()) {
                this.refreshAndFinish(Collections.emptyList(), Collections.emptyList(), false);
                return;
            }
            this.startNextScroll(thisBatchStartTime, response.getItems().length);
        }
        catch (Exception t) {
            this.finishHim(t);
        }
    }

    void startNextScroll(TimeValue lastBatchStartTime, int lastBatchSize) {
        if (this.task.isCancelled()) {
            this.finishHim(null);
            return;
        }
        TimeValue extraKeepAlive = this.task.throttleWaitTime(lastBatchStartTime, lastBatchSize);
        this.scrollSource.startNextScroll(extraKeepAlive, response -> this.onScrollResponse(lastBatchStartTime, lastBatchSize, (ScrollableHitSource.Response)response));
    }

    private void recordFailure(BulkItemResponse.Failure failure, List<BulkItemResponse.Failure> failures) {
        if (failure.getStatus() == RestStatus.CONFLICT) {
            this.task.countVersionConflict();
            if (!((AbstractBulkByScrollRequest)this.mainRequest).isAbortOnVersionConflict()) {
                return;
            }
        }
        failures.add(failure);
    }

    void refreshAndFinish(final List<BulkItemResponse.Failure> indexingFailures, final List<ScrollableHitSource.SearchFailure> searchFailures, final boolean timedOut) {
        if (this.task.isCancelled() || !((AbstractBulkByScrollRequest)this.mainRequest).isRefresh() || this.destinationIndices.isEmpty()) {
            this.finishHim(null, indexingFailures, searchFailures, timedOut);
            return;
        }
        RefreshRequest refresh = new RefreshRequest(new String[0]);
        refresh.indices(this.destinationIndices.toArray(new String[this.destinationIndices.size()]));
        this.client.admin().indices().refresh(refresh, new ActionListener<RefreshResponse>(){

            @Override
            public void onResponse(RefreshResponse response) {
                AbstractAsyncBulkByScrollAction.this.finishHim(null, indexingFailures, searchFailures, timedOut);
            }

            @Override
            public void onFailure(Exception e) {
                AbstractAsyncBulkByScrollAction.this.finishHim(e);
            }
        });
    }

    void finishHim(Exception failure) {
        this.finishHim(failure, Collections.emptyList(), Collections.emptyList(), false);
    }

    void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
        this.scrollSource.close();
        if (failure == null) {
            this.listener.onResponse(this.buildResponse(TimeValue.timeValueNanos(System.nanoTime() - this.startTime.get()), indexingFailures, searchFailures, timedOut));
        } else {
            this.listener.onFailure(failure);
        }
    }

    BackoffPolicy buildBackoffPolicy() {
        return BackoffPolicy.exponentialBackoff(((AbstractBulkByScrollRequest)this.mainRequest).getRetryBackoffInitialTime(), ((AbstractBulkByScrollRequest)this.mainRequest).getMaxRetries());
    }

    void addDestinationIndices(Collection<String> indices) {
        this.destinationIndices.addAll(indices);
    }

    void setScroll(String scroll) {
        this.scrollSource.setScroll(scroll);
    }
}

