/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.Term;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.MultiTermQuery;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.Query;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.search.RegexpQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MultiTermQueryBuilder;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.RegexpFlag;
import org.elasticsearch.index.query.support.QueryParsers;

public class RegexpQueryBuilder
extends AbstractQueryBuilder<RegexpQueryBuilder>
implements MultiTermQueryBuilder {
    public static final String NAME = "regexp";
    public static final int DEFAULT_FLAGS_VALUE = RegexpFlag.ALL.value();
    public static final int DEFAULT_MAX_DETERMINIZED_STATES = 10000;
    private static final ParseField NAME_FIELD = new ParseField("_name", new String[0]).withAllDeprecated("query name is not supported in short version of regexp query");
    private static final ParseField FLAGS_VALUE_FIELD = new ParseField("flags_value", new String[0]);
    private static final ParseField MAX_DETERMINIZED_STATES_FIELD = new ParseField("max_determinized_states", new String[0]);
    private static final ParseField FLAGS_FIELD = new ParseField("flags", new String[0]);
    private static final ParseField REWRITE_FIELD = new ParseField("rewrite", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);
    private final String fieldName;
    private final String value;
    private int flagsValue = DEFAULT_FLAGS_VALUE;
    private int maxDeterminizedStates = 10000;
    private String rewrite;

    public RegexpQueryBuilder(String fieldName, String value) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public RegexpQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readString();
        this.flagsValue = in.readVInt();
        this.maxDeterminizedStates = in.readVInt();
        this.rewrite = in.readOptionalString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(this.value);
        out.writeVInt(this.flagsValue);
        out.writeVInt(this.maxDeterminizedStates);
        out.writeOptionalString(this.rewrite);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String value() {
        return this.value;
    }

    public RegexpQueryBuilder flags(RegexpFlag ... flags) {
        if (flags == null) {
            this.flagsValue = DEFAULT_FLAGS_VALUE;
            return this;
        }
        int value = 0;
        if (flags.length == 0) {
            value = RegexpFlag.ALL.value;
        } else {
            for (RegexpFlag flag : flags) {
                value |= flag.value;
            }
        }
        this.flagsValue = value;
        return this;
    }

    public RegexpQueryBuilder flags(int flags) {
        this.flagsValue = flags;
        return this;
    }

    public int flags() {
        return this.flagsValue;
    }

    public RegexpQueryBuilder maxDeterminizedStates(int value) {
        this.maxDeterminizedStates = value;
        return this;
    }

    public int maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    public RegexpQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public String rewrite() {
        return this.rewrite;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(VALUE_FIELD.getPreferredName(), this.value);
        builder.field(FLAGS_VALUE_FIELD.getPreferredName(), this.flagsValue);
        builder.field(MAX_DETERMINIZED_STATES_FIELD.getPreferredName(), this.maxDeterminizedStates);
        if (this.rewrite != null) {
            builder.field(REWRITE_FIELD.getPreferredName(), this.rewrite);
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    public static Optional<RegexpQueryBuilder> fromXContent(QueryParseContext parseContext) throws IOException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String fieldName = null;
        String rewrite = null;
        String value = null;
        float boost = 1.0f;
        int flagsValue = DEFAULT_FLAGS_VALUE;
        int maxDeterminizedStates = 10000;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                RegexpQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, VALUE_FIELD)) {
                        value = parser.textOrNull();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.BOOST_FIELD)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, REWRITE_FIELD)) {
                        rewrite = parser.textOrNull();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, FLAGS_FIELD)) {
                        String flags = parser.textOrNull();
                        flagsValue = RegexpFlag.resolveValue(flags);
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, MAX_DETERMINIZED_STATES_FIELD)) {
                        maxDeterminizedStates = parser.intValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, FLAGS_VALUE_FIELD)) {
                        flagsValue = parser.intValue();
                        continue;
                    }
                    if (parseContext.getParseFieldMatcher().match(currentFieldName, AbstractQueryBuilder.NAME_FIELD)) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[regexp] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (parseContext.getParseFieldMatcher().match(currentFieldName, NAME_FIELD)) {
                queryName = parser.text();
                continue;
            }
            RegexpQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = currentFieldName;
            value = parser.textOrNull();
        }
        return Optional.of(((RegexpQueryBuilder)new RegexpQueryBuilder(fieldName, value).flags(flagsValue).maxDeterminizedStates(maxDeterminizedStates).rewrite(rewrite).boost(boost)).queryName(queryName));
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws QueryShardException, IOException {
        MultiTermQuery.RewriteMethod method = QueryParsers.parseRewriteMethod(context.getParseFieldMatcher(), this.rewrite, null);
        Query query = null;
        MappedFieldType fieldType = context.fieldMapper(this.fieldName);
        if (fieldType != null) {
            query = fieldType.regexpQuery(this.value, this.flagsValue, this.maxDeterminizedStates, method, context);
        }
        if (query == null) {
            RegexpQuery regexpQuery = new RegexpQuery(new Term(this.fieldName, BytesRefs.toBytesRef(this.value)), this.flagsValue, this.maxDeterminizedStates);
            if (method != null) {
                regexpQuery.setRewriteMethod(method);
            }
            query = regexpQuery;
        }
        return query;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.flagsValue, this.maxDeterminizedStates, this.rewrite);
    }

    @Override
    protected boolean doEquals(RegexpQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.flagsValue, other.flagsValue) && Objects.equals(this.maxDeterminizedStates, other.maxDeterminizedStates) && Objects.equals(this.rewrite, other.rewrite);
    }
}

