/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.geo.GeoEncodingUtils;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;

final class LatLonPointDVAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    private final SortedNumericDocValues values;

    LatLonPointDVAtomicFieldData(SortedNumericDocValues values) {
        this.values = values;
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public void close() {
    }

    @Override
    public MultiGeoPointValues getGeoPointValues() {
        return new MultiGeoPointValues(){
            GeoPoint[] points = new GeoPoint[0];
            private int count = 0;

            @Override
            public void setDocument(int docId) {
                LatLonPointDVAtomicFieldData.this.values.setDocument(docId);
                this.count = LatLonPointDVAtomicFieldData.this.values.count();
                if (this.count > this.points.length) {
                    int previousLength = this.points.length;
                    this.points = Arrays.copyOf(this.points, ArrayUtil.oversize(this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF));
                    for (int i = previousLength; i < this.points.length; ++i) {
                        this.points[i] = new GeoPoint(Double.NaN, Double.NaN);
                    }
                }
                for (int i = 0; i < this.count; ++i) {
                    long encoded = LatLonPointDVAtomicFieldData.this.values.valueAt(i);
                    this.points[i].reset(GeoEncodingUtils.decodeLatitude((int)(encoded >>> 32)), GeoEncodingUtils.decodeLongitude((int)encoded));
                }
            }

            @Override
            public int count() {
                return this.count;
            }

            @Override
            public GeoPoint valueAt(int index) {
                return this.points[index];
            }
        };
    }
}

