/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.DocValues;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointArrayIndexFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointDVAtomicFieldData;
import org.elasticsearch.index.fielddata.plain.GeoPointLegacyDVAtomicFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.MultiValueMode;

public abstract class AbstractGeoPointDVIndexFieldData
extends DocValuesIndexFieldData
implements IndexGeoPointFieldData {
    AbstractGeoPointDVIndexFieldData(Index index, String fieldName) {
        super(index, fieldName);
    }

    @Override
    public final IndexFieldData.XFieldComparatorSource comparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    public static class Builder
    implements IndexFieldData.Builder {
        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            if (indexSettings.getIndexVersionCreated().before(Version.V_2_2_0) && !fieldType.hasDocValues()) {
                return new GeoPointArrayIndexFieldData(indexSettings, fieldType.name(), cache, breakerService);
            }
            return new GeoPointDVIndexFieldData(indexSettings.getIndex(), fieldType.name(), indexSettings.getIndexVersionCreated().before(Version.V_2_2_0));
        }
    }

    public static class GeoPointDVIndexFieldData
    extends AbstractGeoPointDVIndexFieldData {
        final boolean indexCreatedBefore2x;

        public GeoPointDVIndexFieldData(Index index, String fieldName, boolean indexCreatedBefore2x) {
            super(index, fieldName);
            this.indexCreatedBefore2x = indexCreatedBefore2x;
        }

        @Override
        public AtomicGeoPointFieldData load(LeafReaderContext context) {
            try {
                if (this.indexCreatedBefore2x) {
                    return new GeoPointLegacyDVAtomicFieldData(DocValues.getBinary(context.reader(), this.fieldName));
                }
                return new GeoPointDVAtomicFieldData(DocValues.getSortedNumeric(context.reader(), this.fieldName));
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot load doc values", e);
            }
        }

        @Override
        public AtomicGeoPointFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }
    }
}

