/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.CharArraySet;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.StopFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.miscellaneous.FingerprintFilter;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.lucene.analysis.standard.StandardTokenizer;

public final class FingerprintAnalyzer
extends Analyzer {
    private final char separator;
    private final int maxOutputSize;
    private final CharArraySet stopWords;

    public FingerprintAnalyzer(CharArraySet stopWords, char separator, int maxOutputSize) {
        this.separator = separator;
        this.maxOutputSize = maxOutputSize;
        this.stopWords = stopWords;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String s) {
        StandardTokenizer tokenizer;
        TokenStream stream = tokenizer = new StandardTokenizer();
        stream = new LowerCaseFilter(stream);
        stream = new ASCIIFoldingFilter(stream, false);
        stream = new StopFilter(stream, this.stopWords);
        stream = new FingerprintFilter(stream, this.maxOutputSize, this.separator);
        return new Analyzer.TokenStreamComponents(tokenizer, stream);
    }
}

