/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4.pipelining;

import java.util.Collections;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.channel.ChannelPromise;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedRequest;
import org.elasticsearch.http.netty4.pipelining.HttpPipelinedResponse;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class HttpPipeliningHandler
extends ChannelDuplexHandler {
    private static final int INITIAL_EVENTS_HELD = 3;
    private final int maxEventsHeld;
    private int readSequence;
    private int writeSequence;
    private final Queue<HttpPipelinedResponse> holdingQueue;

    public HttpPipeliningHandler(int maxEventsHeld) {
        this.maxEventsHeld = maxEventsHeld;
        this.holdingQueue = new PriorityQueue<HttpPipelinedResponse>(3);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof LastHttpContent) {
            ctx.fireChannelRead(new HttpPipelinedRequest(((LastHttpContent)msg).retain(), this.readSequence++));
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof HttpPipelinedResponse) {
            boolean channelShouldClose = false;
            Queue<HttpPipelinedResponse> queue = this.holdingQueue;
            synchronized (queue) {
                if (this.holdingQueue.size() < this.maxEventsHeld) {
                    HttpPipelinedResponse response;
                    this.holdingQueue.add((HttpPipelinedResponse)msg);
                    while (!this.holdingQueue.isEmpty() && (response = this.holdingQueue.peek()).sequence() == this.writeSequence) {
                        this.holdingQueue.remove();
                        ctx.write(response.response(), response.promise());
                        ++this.writeSequence;
                    }
                } else {
                    channelShouldClose = true;
                }
            }
            if (channelShouldClose) {
                try {
                    Netty4Utils.closeChannels(Collections.singletonList(ctx.channel()));
                }
                finally {
                    ((HttpPipelinedResponse)msg).release();
                    promise.setSuccess();
                }
            }
        } else {
            ctx.write(msg, promise);
        }
    }
}

