/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.apache.flink.streaming.connectors.elasticsearch5.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.Index;

public class MetaStateService
extends AbstractComponent {
    private final NodeEnvironment nodeEnv;

    public MetaStateService(Settings settings, NodeEnvironment nodeEnv) {
        super(settings);
        this.nodeEnv = nodeEnv;
    }

    MetaData loadFullState() throws Exception {
        MetaData globalMetaData = this.loadGlobalState();
        MetaData.Builder metaDataBuilder = globalMetaData != null ? MetaData.builder(globalMetaData) : MetaData.builder();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(this.logger, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetaData != null) {
                metaDataBuilder.put(indexMetaData, false);
                continue;
            }
            this.logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return metaDataBuilder.build();
    }

    @Nullable
    public IndexMetaData loadIndexState(Index index) throws IOException {
        return IndexMetaData.FORMAT.loadLatestState(this.logger, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetaData> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetaData> indexMetaDataList = new ArrayList<IndexMetaData>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            if (excludeIndexPathIdsPredicate.test(indexFolderName)) continue;
            IndexMetaData indexMetaData = IndexMetaData.FORMAT.loadLatestState(this.logger, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetaData != null) {
                String indexPathId = indexMetaData.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetaDataList.add(indexMetaData);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            this.logger.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetaDataList;
    }

    MetaData loadGlobalState() throws IOException {
        MetaData globalState = MetaData.FORMAT.loadLatestState(this.logger, this.nodeEnv.nodeDataPaths());
        if (globalState != null) {
            return MetaData.addDefaultUnitsIfNeeded(this.logger, globalState);
        }
        return null;
    }

    public void writeIndex(String reason, IndexMetaData indexMetaData) throws IOException {
        Index index = indexMetaData.getIndex();
        this.logger.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            IndexMetaData.FORMAT.write(indexMetaData, this.nodeEnv.indexPaths(indexMetaData.getIndex()));
        }
        catch (Exception ex) {
            this.logger.warn(() -> new ParameterizedMessage("[{}]: failed to write index state", (Object)index), (Throwable)ex);
            throw new IOException("failed to write state for [" + index + "]", ex);
        }
    }

    void writeGlobalState(String reason, MetaData metaData) throws Exception {
        this.logger.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            MetaData.FORMAT.write(metaData, this.nodeEnv.nodeDataPaths());
        }
        catch (Exception ex) {
            this.logger.warn("[_global]: failed to write global state", (Throwable)ex);
            throw new IOException("failed to write global state", ex);
        }
    }
}

